/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.rest.api.issue;

import com.atlassian.jira.rest.api.issue.FieldOperation;
import com.atlassian.jira.rest.api.issue.IssueFields;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.codehaus.jackson.annotate.JsonIgnoreProperties;
import org.codehaus.jackson.annotate.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown=true)
public class IssueUpdateRequest {
    @JsonProperty
    protected Map<String, List<FieldOperation>> update = Maps.newHashMap();
    @JsonProperty
    protected IssueFields fields;
    static final IssueUpdateRequest DOC_EXAMPLE;

    public IssueFields fields() {
        return this.fields;
    }

    public IssueUpdateRequest fields(IssueFields fields) {
        this.fields = fields;
        return this;
    }

    public Map<String, List<FieldOperation>> update() {
        return this.update;
    }

    public IssueUpdateRequest update(Map<String, List<FieldOperation>> update) {
        this.update = update;
        return this;
    }

    public IssueUpdateRequest update(String field, List<FieldOperation> updates) {
        this.update.put(field, updates);
        return this;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    static {
        IssueUpdateRequest issueUpdateRequest = new IssueUpdateRequest();
        issueUpdateRequest.update = new HashMap<String, List<FieldOperation>>();
        ArrayList<FieldOperation> summaryOperations = new ArrayList<FieldOperation>();
        FieldOperation summaryOperation = new FieldOperation();
        summaryOperation.init("set", "Bug in business logic");
        summaryOperations.add(summaryOperation);
        issueUpdateRequest.update.put("summary", summaryOperations);
        ArrayList<FieldOperation> componentsOperations = new ArrayList<FieldOperation>();
        FieldOperation componentsOperation = new FieldOperation();
        componentsOperation.init("clear", "");
        componentsOperations.add(componentsOperation);
        issueUpdateRequest.update.put("components", componentsOperations);
        ArrayList<FieldOperation> labelOperations = new ArrayList<FieldOperation>();
        FieldOperation labelOperation1 = new FieldOperation();
        labelOperation1.init("add", "triaged");
        labelOperations.add(labelOperation1);
        FieldOperation labelOperation2 = new FieldOperation();
        labelOperation2.init("remove", "blocker");
        labelOperations.add(labelOperation2);
        issueUpdateRequest.update.put("labels", labelOperations);
        DOC_EXAMPLE = issueUpdateRequest;
    }
}

