/**
 * @module quick-edit/util/extension-mixin
 */
define('quick-edit/util/extension-mixin', [
    'jquery'
], function(
    jQuery
){
    'use strict';

    /**
     * Triggers event on an instance
     *
     * @param {String} evtName - Event Name
     * @param {Array} args - Args to pass to event handlers
     */
    var triggerEvent = function (evtName, args, global) {
        jQuery(this).trigger(evtName, args);

        if (global && this.globalEventNamespaces) {
            jQuery.each(this.globalEventNamespaces, function (i, glbEvtName) {
                jQuery(document).trigger(glbEvtName + "." + evtName, args);
            });
        }
        return this;
    };

    return {
        triggerEvent: triggerEvent
    };
});