define('quick-edit/init/edit',
[
    'quick-edit/form/factory/edit-issue',
    'quick-edit/util/dialog',
    'aui/tabs',
    'jquery'
], function(
    editIssueFormFactory,
    DialogUtil,
    AuiTabs,
    jQuery
){
    'use strict';

    var initDialog = function () {
        var dialog = editIssueFormFactory()
            .asDialog({
                windowTitle: function () {
                    return DialogUtil.getIssueActionTitle(AJS.I18n.getText("admin.issue.operations.edit"));
                },
                id: "edit-issue-dialog"
            });
        // Ensure tabs are initiated
        jQuery(document).bind("dialogContentReady", function () {
            AuiTabs.setup();
        });

        return dialog;
    }

    return {initDialog: initDialog}
});
