/**
 * @module quick-edit/form/model/factory/edit-issue
 */
define('quick-edit/form/model/factory/edit-issue', [
    'quick-edit/form/model/edit-issue',
    'wrm/context-path'
], function(
    EditIssueFormModel,
    contextPath
){
    'use strict';

    /**
     * Factory to create {@link EditIssueFormModel}
     *
     * @param {String, Number} issueId
     * @return EditIssueFormModel
     */
     return function (issueId) {
        return new EditIssueFormModel({
            fieldsResource: contextPath() + "/secure/QuickEditIssue!default.jspa?issueId=" + issueId + "&decorator=none",
            userFieldsResource: contextPath() + "/rest/quickedit/1.0/userpreferences/edit"
        });
    };
});

/**
 * @deprecated JIRA.Forms.Model.createQuickEditIssueModel
 */
AJS.namespace('JIRA.Forms.Model.createQuickEditIssueModel', null, require('quick-edit/form/model/factory/edit-issue'));