/**
 * @module quick-edit/form/factory/create-subtask
 */
define('quick-edit/form/factory/create-subtask', [
    'quick-edit/form/container',
    'quick-edit/form/configurable/create-issue',
    'quick-edit/form/error/create-issue',
    'quick-edit/form/model/create-issue',
    'quick-edit/form/unconfigurable-create-issue',
    'quick-edit/util/dialog',
    'jira/issue',
    'jira/issuenavigator/issue-navigator'
], function(
    Container,
    ConfigurableCreateIssueForm,
    CreateIssueError,
    CreateIssueModel,
    UnconfigurableCreateIssueForm,
    DialogUtil,
    Issue,
    IssueNavigator
){
    'use strict';

    function getParentIssueId (options) {
        return options.parentIssueId || Issue.getIssueId() || IssueNavigator.getSelectedIssueId();
    }

    /**
     * Factory to create subtask form
     *
     * @return FormContainer
     */
    return function subtaskForm(options) {
        options = options || {};

        return new Container(function () {
            options.globalEventNamespaces = options.globalEventNamespaces || ["QuickCreateSubtask"];

            // model that gets fields and sets user preferences
            var parentIssueId = getParentIssueId(options),
                title = DialogUtil.getIssueActionTitle(AJS.I18n.getText("issue.create.subtask")),
                model = new CreateIssueModel({
                    parentIssueId: parentIssueId,
                    projectId: options.pid,
                    issueType: options.issueType
                }),
                configurableForm = new ConfigurableCreateIssueForm({
                    model: model,
                    title: title,
                    globalEventNamespaces: options.globalEventNamespaces
                }),
                unconfigurableForm = new UnconfigurableCreateIssueForm({
                    model: model,
                    title: title,
                    globalEventNamespaces: options.globalEventNamespaces
                });

            return {
                globalEventNamespaces: options.globalEventNamespaces,
                model: model,
                errorHandler: new CreateIssueError(),
                configurableForm: configurableForm,
                unconfigurableForm: unconfigurableForm
            };
        });
    };
});

/**
 * @deprecated JIRA.Forms.createSubtaskForm
 */
AJS.namespace('JIRA.Forms.createSubtaskForm', null, require('quick-edit/form/factory/create-subtask'));