require([
    'jquery',
    'wrm/require',
    'quick-edit/util/loading-indicator'
], function (
    jQuery,
    wrmRequire,
    LoadingIndicator
) {
    var showLoadingIndicator = function () {
        LoadingIndicator.showLoadingIndicator();
    };
    var hideLoadingIndicator = function () {
        LoadingIndicator.hideLoadingIndicator(true);
    };

    var createIssueDialogLoading = false;
    jQuery(document).on("click", ".issueaction-create-linked-issue", function(e) {
        e.preventDefault();
        if( !createIssueDialogLoading ) {
            createIssueDialogLoading = true;
            showLoadingIndicator();

            wrmRequire(['wr!com.atlassian.jira.jira-quick-edit-plugin:create-linked-issue'])
                .done(function () {
                    var formFactory = require('quick-edit/create-linked-issue/create-linked-issue-form-factory');

                    formFactory().asDialog({
                        id: "create-linked-issue-dialog",
                        windowTitle: AJS.I18n.getText('createlinkedissue.title')
                    }).show();

                    createIssueDialogLoading = false;
                })
                .fail(function () {
                    hideLoadingIndicator();
                    createIssueDialogLoading = false;
                });
        }
    });
});