/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.quickedit.condition;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.plugin.web.Condition;
import java.util.Map;
import java.util.Optional;

public class CreateLinkedIssueProjectTypeCondition
implements Condition {
    private static final String PROJECT_CONTEXT_KEY = "project";
    private static final String JIRA_CORE_PROJECT_TYPE_KEY = "business";
    private static final String JIRA_SERVICE_DESK_PROJECT_TYPE_KEY = "service_desk";

    public void init(Map<String, String> params) {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        if (!context.containsKey(PROJECT_CONTEXT_KEY)) {
            return false;
        }
        Project project = (Project)context.get(PROJECT_CONTEXT_KEY);
        Optional<ProjectTypeKey> type = Optional.ofNullable(project.getProjectTypeKey());
        return type.map(projectTypeKey -> this.shouldDisplayFor(projectTypeKey.getKey())).orElse(false);
    }

    private boolean shouldDisplayFor(String projectTypeKey) {
        return JIRA_CORE_PROJECT_TYPE_KEY.equals(projectTypeKey) || JIRA_SERVICE_DESK_PROJECT_TYPE_KEY.equals(projectTypeKey);
    }
}

