/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.quickedit.action;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.bc.issue.attachment.AttachmentService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.IssueLinksSystemField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.rest.FieldHtmlFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.FieldHtmlBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.link.IssueLink;
import com.atlassian.jira.issue.link.IssueLinkManager;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.issue.link.RemoteIssueLinkManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.quickedit.action.QuickCreateIssue;
import com.atlassian.jira.quickedit.rest.api.field.CreateLinkedIssueFields;
import com.atlassian.jira.quickedit.rest.api.field.QuickEditFields;
import com.atlassian.jira.quickedit.user.UserPreferencesStore;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.UserIssueTypeManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import io.atlassian.fugue.Either;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import webwork.action.Action;
import webwork.action.ActionContext;

public class QuickCreateLinkedIssue
extends QuickCreateIssue {
    private final IssueService issueService;
    private final FieldHtmlFactory fieldHtmlFactory;
    private final AttachmentService attachmentService;
    private final AttachmentManager attachmentManager;
    private final IssueLinkManager issueLinkManager;
    private final RemoteIssueLinkManager remoteIssueLinkManager;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private static final String ISSUE_TEMPLATES = "com.atlassian.jira.jira-quick-edit-plugin:quick-create-issue";
    private static final String CHECKBOX_TEMPLATE = "JIRA.Templates.Issue.checkBoxField";
    private String sourceIssueKey;
    private boolean copyAttachments;
    private boolean copyLinks;
    private List<String> postIssueCreationErrorMessages;
    private MutableIssue sourceIssue;

    public QuickCreateLinkedIssue(IssueFactory issueFactory, IssueCreationHelperBean issueCreationHelperBean, IssueService issueService, UserPreferencesStore userPreferencesStore, UserProjectHistoryManager userProjectHistoryManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, IssueTypeSchemeManager issueTypeSchemeManager, UserIssueHistoryManager userIssueHistoryManager, SubTaskManager subTaskManager, FieldHtmlFactory fieldHtmlFactory, BeanBuilderFactory beanBuilderFactory, JiraBaseUrls jiraBaseUrls, TemporaryWebAttachmentManager temporaryAttachmentManager, UserIssueTypeManager userIssueTypeManager, AttachmentManager attachmentManager, AttachmentService attachmentService, IssueLinkManager issueLinkManager, RemoteIssueLinkManager remoteIssueLinkManager, SoyTemplateRenderer soyTemplateRenderer) {
        super(issueFactory, issueCreationHelperBean, issueService, userPreferencesStore, userProjectHistoryManager, applicationProperties, permissionManager, issueTypeSchemeManager, userIssueHistoryManager, subTaskManager, fieldHtmlFactory, beanBuilderFactory, jiraBaseUrls, temporaryAttachmentManager, userIssueTypeManager);
        this.issueService = issueService;
        this.fieldHtmlFactory = fieldHtmlFactory;
        this.attachmentService = attachmentService;
        this.attachmentManager = attachmentManager;
        this.issueLinkManager = issueLinkManager;
        this.remoteIssueLinkManager = remoteIssueLinkManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.postIssueCreationErrorMessages = new LinkedList<String>();
        this.sourceIssue = null;
    }

    @Override
    protected <T extends QuickEditFields.Builder> T getFieldsBuilder() {
        return (T)new CreateLinkedIssueFields.Builder();
    }

    @Override
    protected Either<ErrorCollection, List<FieldHtmlBean>> getCreateFields(MutableIssue newIssueObject) {
        ErrorCollection errorCollection;
        if (this.sourceIssue == null && (errorCollection = this.validateAndSetSourceIssue()).hasAnyErrors()) {
            return Either.left((Object)errorCollection);
        }
        this.sourceIssue.setReporter(this.getLoggedInUser());
        this.sourceIssue.setAssignee(null);
        List createFields = this.fieldHtmlFactory.getLinkedIssueCreateFields(this.getLoggedInUser(), (OperationContext)this, (Action)this, newIssueObject, (Issue)this.sourceIssue, this.isRetainValues(), this.getFieldsToRetainAsList());
        return Either.right((Object)createFields);
    }

    @Override
    protected <T extends QuickEditFields.Builder> void addAdditionalFields(T fieldsBuilder) {
        CreateLinkedIssueFields.Builder builder = (CreateLinkedIssueFields.Builder)fieldsBuilder;
        Project selectedProject = this.getProjectManager().getProjectObj(this.getPid());
        if (this.showAttachmentsCheckbox(selectedProject)) {
            fieldsBuilder.addField(this.createCheckBoxField("copyAttachments", this.getText("createlinkedissue.copy.attachments.label")));
        }
        if (this.showLinksCheckbox()) {
            fieldsBuilder.addField(this.createCheckBoxField("copyLinks", this.getText("createlinkedissue.copy.links.label")));
        }
        builder.addPostIssueCreationErrorMessages(this.postIssueCreationErrorMessages);
    }

    private boolean showLinksCheckbox() {
        return this.issueLinkManager.isLinkingEnabled() && this.isIssueWithLinks();
    }

    private boolean showAttachmentsCheckbox(Project selectedProject) {
        return this.attachmentManager.attachmentsEnabled() && this.attachmentService.canCreateAttachments(this.getJiraServiceContext(), selectedProject) && this.isIssueWithAttachments();
    }

    private boolean isIssueWithAttachments() {
        return this.sourceIssue != null && this.sourceIssue.getAttachments() != null && !this.sourceIssue.getAttachments().isEmpty();
    }

    private boolean isIssueWithLinks() {
        if (this.sourceIssue == null || this.sourceIssue.getId() == null) {
            return false;
        }
        Stream links = Stream.concat(this.issueLinkManager.getOutwardLinks(this.sourceIssue.getId()).stream(), this.issueLinkManager.getInwardLinks(this.sourceIssue.getId()).stream());
        return links.map(IssueLink::getIssueLinkType).anyMatch(issueLinkType -> !issueLinkType.isSubTaskLinkType()) || !this.remoteIssueLinkManager.getRemoteIssueLinksForIssue((Issue)this.sourceIssue).isEmpty();
    }

    @Override
    protected ErrorCollection getAdditionalValidationErrors(MutableIssue issue) {
        ErrorCollection sourceIssueErrorCollection;
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        if (issue != null) {
            errorCollection = this.validateAndSetIssueLinks(issue, (ErrorCollection)errorCollection);
        }
        if (!errorCollection.hasAnyErrors() && (sourceIssueErrorCollection = this.validateAndSetSourceIssue()).hasAnyErrors()) {
            errorCollection.addErrorCollection(sourceIssueErrorCollection);
        }
        return errorCollection;
    }

    private ErrorCollection validateAndSetIssueLinks(MutableIssue issue, ErrorCollection errorCollection) {
        IssueLinksSystemField issueLinksField = (IssueLinksSystemField)this.getField("issuelinks");
        issueLinksField.populateFromParams(this.getFieldValuesHolder(), ActionContext.getParameters());
        issueLinksField.validateParams((OperationContext)this, errorCollection, (I18nHelper)this, (Issue)issue, null);
        if (!errorCollection.hasAnyErrors()) {
            issue.setExternalFieldValue("issuelinks", this.getFieldValuesHolder().get("issuelinks"));
        }
        return errorCollection;
    }

    private ErrorCollection validateAndSetSourceIssue() {
        SimpleErrorCollection errorCollection = new SimpleErrorCollection();
        IssueService.IssueResult sourceIssueResult = this.issueService.getIssue(this.getLoggedInUser(), this.sourceIssueKey);
        if (sourceIssueResult.isValid()) {
            this.sourceIssue = sourceIssueResult.getIssue();
        } else {
            errorCollection = sourceIssueResult.getErrorCollection();
        }
        return errorCollection;
    }

    @Override
    protected void doPostIssueCreation(MutableIssue createdIssue) {
        if (this.isCopyAttachments()) {
            this.copyAttachments(createdIssue);
        }
        if (this.isCopyLinks() && this.issueLinkManager.isLinkingEnabled()) {
            this.copyLinks((Issue)createdIssue);
        }
    }

    private FieldHtmlBean createCheckBoxField(@Nonnull String name, String label) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("name", name);
        data.put("label", label);
        data.put("checked", (String)ActionContext.getSingleValueParameters().get(name));
        return new FieldHtmlBean(name, label, false, this.soyTemplateRenderer.render(ISSUE_TEMPLATES, CHECKBOX_TEMPLATE, data), null);
    }

    private void copyAttachments(MutableIssue createdIssue) {
        LinkedList<String> errorAttachmentFileNames = new LinkedList<String>();
        Map copyResult = this.attachmentManager.copyAttachments((Issue)this.sourceIssue, this.getLoggedInUser(), createdIssue.getKey());
        for (Either attachmentEither : copyResult.values()) {
            if (!attachmentEither.isLeft()) continue;
            errorAttachmentFileNames.add(((AttachmentError)attachmentEither.left().get()).getFilename());
        }
        if (errorAttachmentFileNames.size() > 0) {
            String copyAttachmentsErrorMessage = this.getText("createlinkedissue.copy.attachments.error.message", StringUtils.join((Object[])errorAttachmentFileNames.toArray(), (String)", "));
            this.postIssueCreationErrorMessages.add(copyAttachmentsErrorMessage);
        }
    }

    private void copyLinks(Issue createdIssue) {
        Long createdIssueId = createdIssue.getId();
        FailureCounter failureCounter = new FailureCounter();
        this.copyInwardLinks(createdIssueId, failureCounter);
        this.copyOutwardLinks(createdIssueId, failureCounter);
        this.copyRemoteLinks(createdIssueId, failureCounter);
        if (failureCounter.failureCount > 0) {
            String copyLinksErrorMessage = this.getText("createlinkedissue.copy.links.error.message", failureCounter.failureCount);
            this.postIssueCreationErrorMessages.add(copyLinksErrorMessage);
        }
    }

    private void copyInwardLinks(Long createdIssueId, FailureCounter failureCounter) {
        this.issueLinkManager.getInwardLinks(this.sourceIssue.getId()).stream().filter(link -> !link.isSystemLink()).filter(link -> link.getSourceId() != null).filter(link -> !link.getSourceId().equals(createdIssueId)).forEach(link -> this.createIssueLink(link.getSourceId(), createdIssueId, link.getLinkTypeId(), failureCounter));
    }

    private void copyOutwardLinks(Long createdIssueId, FailureCounter failureCounter) {
        this.issueLinkManager.getOutwardLinks(this.sourceIssue.getId()).stream().filter(link -> !link.isSystemLink()).filter(link -> link.getDestinationId() != null).filter(link -> !link.getDestinationId().equals(createdIssueId)).forEach(link -> this.createIssueLink(createdIssueId, link.getDestinationId(), link.getLinkTypeId(), failureCounter));
    }

    private void createIssueLink(Long sourceIssueId, Long destinationIssueId, Long linkTypeId, FailureCounter failureCounter) {
        try {
            this.issueLinkManager.createIssueLink(sourceIssueId, destinationIssueId, linkTypeId, null, this.getLoggedInUser());
        }
        catch (CreateException e) {
            failureCounter.count("Cannot copy issue link.", e);
        }
    }

    private void copyRemoteLinks(Long createdIssueId, FailureCounter failureCounter) {
        this.remoteIssueLinkManager.getRemoteIssueLinksForIssue((Issue)this.sourceIssue).forEach(link -> this.createRemoteLink(createdIssueId, (RemoteIssueLink)link, failureCounter));
    }

    private void createRemoteLink(Long issueId, RemoteIssueLink originalRemoteLink, FailureCounter failureCounter) {
        RemoteIssueLink remoteLink = new RemoteIssueLinkBuilder(originalRemoteLink).id(null).issueId(issueId).build();
        try {
            this.remoteIssueLinkManager.createRemoteIssueLink(remoteLink, this.getLoggedInUser());
        }
        catch (CreateException e) {
            failureCounter.count("Cannot copy remote issue link.", e);
        }
    }

    public String getSourceIssueKey() {
        return this.sourceIssueKey;
    }

    public void setSourceIssueKey(String sourceIssueKey) {
        this.sourceIssueKey = sourceIssueKey;
    }

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
    }

    public boolean isCopyLinks() {
        return this.copyLinks;
    }

    public void setCopyLinks(boolean copyLinks) {
        this.copyLinks = copyLinks;
    }

    private class FailureCounter {
        private int failureCount = 0;

        private FailureCounter() {
        }

        private void count(String errorMessage, CreateException exception) {
            QuickCreateLinkedIssue.this.log.error((Object)errorMessage, (Throwable)exception);
            ++this.failureCount;
        }
    }
}

