/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.quickedit.action;

import com.atlassian.jira.bc.issue.IssueService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.CreateException;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueFactory;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.issue.attachment.TemporaryWebAttachmentManager;
import com.atlassian.jira.issue.customfields.OperationContext;
import com.atlassian.jira.issue.fields.IssueTypeSystemField;
import com.atlassian.jira.issue.fields.ProjectSystemField;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.rest.FieldHtmlFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.FieldHtmlBean;
import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.issue.issuetype.IssueTypeId;
import com.atlassian.jira.issue.operation.IssueOperation;
import com.atlassian.jira.issue.operation.IssueOperations;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.quickedit.action.JsonActionSupport;
import com.atlassian.jira.quickedit.rest.api.field.MinimalIssueBean;
import com.atlassian.jira.quickedit.rest.api.field.QuickEditFields;
import com.atlassian.jira.quickedit.user.UserPreferencesStore;
import com.atlassian.jira.rest.api.util.ErrorCollection;
import com.atlassian.jira.rest.v2.issue.IncludedFields;
import com.atlassian.jira.rest.v2.issue.IssueBean;
import com.atlassian.jira.rest.v2.issue.builder.BeanBuilderFactory;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.UserIssueHistoryManager;
import com.atlassian.jira.user.UserIssueTypeManager;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.issue.IssueCreationHelperBean;
import com.atlassian.security.random.DefaultSecureTokenGenerator;
import com.atlassian.security.random.SecureTokenGenerator;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Either;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.core.UriBuilder;
import webwork.action.Action;
import webwork.action.ActionContext;

public class QuickCreateIssue
extends JiraWebActionSupport
implements OperationContext {
    private final UserPreferencesStore userPreferencesStore;
    private final UserProjectHistoryManager userProjectHistoryManager;
    private final ApplicationProperties applicationProperties;
    private final PermissionManager permissionManager;
    private final IssueTypeSchemeManager issueTypeSchemeManager;
    private final UserIssueHistoryManager userIssueHistoryManager;
    private final SubTaskManager subTaskManager;
    private final FieldHtmlFactory fieldHtmlFactory;
    private final IssueFactory issueFactory;
    private final IssueCreationHelperBean issueCreationHelperBean;
    private final IssueService issueService;
    private final TemporaryWebAttachmentManager temporaryAttachmentManager;
    private final SecureTokenGenerator secureTokenGenerator = DefaultSecureTokenGenerator.getInstance();
    private final Map<String, Object> fieldValuesHolder = new HashMap<String, Object>();
    private Long pid;
    private boolean retainValues;
    private boolean toggle;
    private boolean multipleMode;
    private MinimalIssueBean issue;
    private String issuetype;
    private List<String> fieldsToRetain;
    private MutableIssue issueObject = null;
    private String createdIssueKey;
    private Long parentIssueId = null;
    private IssueService.CreateValidationResult validationResult;
    private MutableIssue createdIssueObject;
    private BeanBuilderFactory beanBuilderFactory;
    private JiraBaseUrls jiraBaseUrls;
    private final UserIssueTypeManager userIssueTypeManager;
    private final JsonActionSupport jsonActionSupport;
    private String formToken;

    public QuickCreateIssue(IssueFactory issueFactory, IssueCreationHelperBean issueCreationHelperBean, IssueService issueService, UserPreferencesStore userPreferencesStore, UserProjectHistoryManager userProjectHistoryManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, IssueTypeSchemeManager issueTypeSchemeManager, UserIssueHistoryManager userIssueHistoryManager, SubTaskManager subTaskManager, FieldHtmlFactory fieldHtmlFactory, BeanBuilderFactory beanBuilderFactory, JiraBaseUrls jiraBaseUrls, TemporaryWebAttachmentManager temporaryAttachmentManager, UserIssueTypeManager userIssueTypeManager) {
        this.issueFactory = issueFactory;
        this.issueCreationHelperBean = issueCreationHelperBean;
        this.issueService = issueService;
        this.userPreferencesStore = userPreferencesStore;
        this.userProjectHistoryManager = userProjectHistoryManager;
        this.applicationProperties = applicationProperties;
        this.permissionManager = permissionManager;
        this.issueTypeSchemeManager = issueTypeSchemeManager;
        this.userIssueHistoryManager = userIssueHistoryManager;
        this.subTaskManager = subTaskManager;
        this.fieldHtmlFactory = fieldHtmlFactory;
        this.beanBuilderFactory = beanBuilderFactory;
        this.temporaryAttachmentManager = temporaryAttachmentManager;
        this.jiraBaseUrls = jiraBaseUrls;
        this.userIssueTypeManager = userIssueTypeManager;
        this.jsonActionSupport = new JsonActionSupport();
    }

    protected <T extends QuickEditFields.Builder> T getFieldsBuilder() {
        return (T)new QuickEditFields.Builder();
    }

    public String doDefault() throws Exception {
        MutableIssue newIssueObject;
        this.issueCreationHelperBean.validateLicense((com.atlassian.jira.util.ErrorCollection)this, (I18nHelper)this);
        if (this.hasAnyErrors()) {
            return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)this));
        }
        Collection projects = this.permissionManager.getProjects(ProjectPermissions.CREATE_ISSUES, this.getLoggedInUser());
        if (projects.isEmpty()) {
            String errorMessage = this.getText(this.getLoggedInUser() == null ? "createissue.notloggedin" : "createissue.projectnopermission");
            return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)this.getSimpleErrorCollection(errorMessage)));
        }
        MutableIssue mutableIssue = newIssueObject = this.issueObject == null ? this.issueFactory.getIssue() : this.issueObject;
        if (this.parentIssueId != null) {
            if (!this.subTaskManager.isSubTasksEnabled()) {
                return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)this.getSimpleErrorCollection("admin.errors.subtasks.disabled")));
            }
            IssueService.IssueResult parentIssueResult = this.issueService.getIssue(this.getLoggedInUser(), this.parentIssueId);
            if (!parentIssueResult.isValid()) {
                return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)parentIssueResult.getErrorCollection()));
            }
            Project parentProject = parentIssueResult.getIssue().getProjectObject();
            this.tagMauEventWithProject(this.getProjectManager().getProjectObj(this.getPid()));
            Collection subTaskIssueTypesForProject = this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(parentProject);
            if (subTaskIssueTypesForProject.isEmpty()) {
                return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)this.getSimpleErrorCollection("issue.subtask.error.no.subtask.types")));
            }
            newIssueObject.setParentId(this.parentIssueId);
            this.setSelectedPid(parentProject.getId());
            this.setSelectedIssueTypeId(parentProject, true);
        } else {
            this.setSelectedPid(null);
            this.setSelectedIssueTypeId(this.getProjectManager().getProjectObj(this.getPid()), false);
        }
        if (this.getFormToken() == null) {
            this.setFormToken(this.secureTokenGenerator.generateToken());
        }
        this.fieldValuesHolder.put("formToken", this.getFormToken());
        SimpleErrorCollection simpleErrorCollection = this.validateIssueTypeAndProject(newIssueObject);
        if (simpleErrorCollection.hasAnyErrors()) {
            return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)simpleErrorCollection));
        }
        Object fieldsBuilder = this.getFieldsBuilder();
        Either<com.atlassian.jira.util.ErrorCollection, List<FieldHtmlBean>> createFieldsEither = this.getCreateFields(newIssueObject);
        if (createFieldsEither.isLeft()) {
            return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)((com.atlassian.jira.util.ErrorCollection)createFieldsEither.left().get())));
        }
        ((QuickEditFields.Builder)fieldsBuilder).addFields((List)createFieldsEither.right().get());
        this.userIssueTypeManager.setLastUsedIssueTypeId(this.getLoggedInUser(), new IssueTypeId(newIssueObject.getIssueType().getId()));
        if (this.createdIssueKey != null) {
            ((QuickEditFields.Builder)fieldsBuilder).createdIssue(this.createdIssueKey);
        }
        if (this.createdIssueObject != null) {
            ((QuickEditFields.Builder)fieldsBuilder).createdIssueDetails(this.getIssueBean((Issue)this.createdIssueObject));
        }
        ((QuickEditFields.Builder)((QuickEditFields.Builder)((QuickEditFields.Builder)fieldsBuilder).addUserPreferences(this.userPreferencesStore.getCreateUserPreferences(this.getLoggedInUser()))).addAltToken(this.getXsrfToken())).addFormToken(this.getFormToken());
        this.addAdditionalFields(fieldsBuilder);
        return this.jsonActionSupport.asJson(((QuickEditFields.Builder)fieldsBuilder).build());
    }

    protected <T extends QuickEditFields.Builder> void addAdditionalFields(T fieldsBuilder) {
    }

    protected Either<com.atlassian.jira.util.ErrorCollection, List<FieldHtmlBean>> getCreateFields(MutableIssue newIssueObject) {
        List createFields = this.parentIssueId != null ? this.fieldHtmlFactory.getSubTaskCreateFields(this.getLoggedInUser(), (OperationContext)this, (Action)this, newIssueObject, this.retainValues, this.fieldsToRetain) : this.fieldHtmlFactory.getCreateFields(this.getLoggedInUser(), (OperationContext)this, (Action)this, newIssueObject, this.retainValues, this.fieldsToRetain);
        return Either.right((Object)createFields);
    }

    private ErrorCollection getValidationErrors() {
        com.atlassian.jira.util.ErrorCollection additionalErrors;
        this.validationResult = this.parentIssueId != null ? this.issueService.validateSubTaskCreate(this.getLoggedInUser(), this.parentIssueId, this.issueService.newIssueInputParameters(ActionContext.getParameters())) : this.issueService.validateCreate(this.getLoggedInUser(), this.issueService.newIssueInputParameters(ActionContext.getParameters()));
        this.issueObject = this.validationResult.getIssue();
        this.setFieldValuesHolder(this.validationResult.getFieldValuesHolder());
        SimpleErrorCollection simpleErrorCollection = this.getSimpleErrorCollection(new String[0]);
        if (!this.validationResult.isValid()) {
            simpleErrorCollection.addErrorCollection(this.validationResult.getErrorCollection());
        }
        if ((additionalErrors = this.getAdditionalValidationErrors(this.validationResult.getIssue())).hasAnyErrors()) {
            simpleErrorCollection.addErrorCollection(additionalErrors);
        }
        return ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)simpleErrorCollection);
    }

    protected com.atlassian.jira.util.ErrorCollection getAdditionalValidationErrors(MutableIssue issue) {
        return this.getSimpleErrorCollection(new String[0]);
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        ErrorCollection validationErrors = this.getValidationErrors();
        if (validationErrors.hasAnyErrors()) {
            return this.jsonActionSupport.asJson(this.getErrorReturnCode(), validationErrors);
        }
        try {
            IssueService.IssueResult issueResult = this.issueService.create(this.getLoggedInUser(), this.validationResult);
            if (!issueResult.isValid()) {
                return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)issueResult.getErrorCollection()));
            }
            this.issueObject = issueResult.getIssue();
            if (this.getFormToken() == null) {
                this.setFormToken(this.secureTokenGenerator.generateToken());
            }
            this.temporaryAttachmentManager.clearTemporaryAttachmentsByFormToken(this.getFormToken());
            if (this.parentIssueId != null) {
                try {
                    IssueService.IssueResult parentIssueResult = this.issueService.getIssue(this.getLoggedInUser(), this.parentIssueId);
                    this.subTaskManager.createSubTaskIssueLink((Issue)parentIssueResult.getIssue(), (Issue)this.issueObject, this.getLoggedInUser());
                }
                catch (CreateException e) {
                    return this.jsonActionSupport.asJson(this.getErrorReturnCode(), ErrorCollection.of((com.atlassian.jira.util.ErrorCollection)this.getSimpleErrorCollection("admin.errors.project.import.issue.link.error")));
                }
            }
            this.userIssueHistoryManager.addIssueToHistory(this.getLoggedInUser(), (Issue)this.issueObject);
            this.doPostIssueCreation(this.issueObject);
            if (this.fieldsToRetain != null) {
                this.createdIssueKey = issueResult.getIssue().getKey();
                this.createdIssueObject = this.issueObject;
                this.issueObject = null;
                HashMap<String, Object> retainedValues = Maps.newHashMap();
                for (Map.Entry<String, Object> input : this.getFieldValuesHolder().entrySet()) {
                    if (null == input || !this.fieldsToRetain.contains(input.getKey())) continue;
                    retainedValues.put(input.getKey(), input.getValue());
                }
                this.setFieldValuesHolder(retainedValues);
                return this.doDefault();
            }
            this.issue = new MinimalIssueBean(issueResult.getIssue().getKey(), issueResult.getIssue().getId(), this.getIssueBean((Issue)this.issueObject));
            return this.jsonActionSupport.asJson(this.issue);
        }
        catch (Exception e) {
            this.log.error((Object)e, (Throwable)e);
            return this.jsonActionSupport.asJson(400, ErrorCollection.of((String[])new String[]{this.getText("admin.errors.issues.exception.occured", e)}));
        }
    }

    protected void doPostIssueCreation(MutableIssue createdIssue) {
    }

    private SimpleErrorCollection getSimpleErrorCollection(String ... errorMessages) {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        for (String errorMessage : errorMessages) {
            simpleErrorCollection.addErrorMessage(this.getText(errorMessage));
        }
        return simpleErrorCollection;
    }

    private IssueBean getIssueBean(Issue issue) {
        IncludedFields include = IncludedFields.includeAllByDefault(ImmutableList.of());
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.jiraBaseUrls.restApi2BaseUrl());
        return this.beanBuilderFactory.newIssueBeanBuilder2(include, null, uriBuilder).build(issue);
    }

    private int getErrorReturnCode() {
        if (this.getLoggedInUser() == null) {
            return 401;
        }
        return 400;
    }

    private SimpleErrorCollection validateIssueTypeAndProject(MutableIssue issue) {
        try {
            issue.setProjectId(this.getPid());
            if (this.getPid() != null) {
                issue.setIssueTypeId(this.getIssuetype());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.validateProjectAndIssueType((Issue)issue);
    }

    private SimpleErrorCollection validateProjectAndIssueType(Issue issue) {
        SimpleErrorCollection simpleErrorCollection = new SimpleErrorCollection();
        ProjectSystemField projectField = (ProjectSystemField)this.getField("project");
        projectField.validateParams((OperationContext)this, (com.atlassian.jira.util.ErrorCollection)simpleErrorCollection, (I18nHelper)this, issue, null);
        IssueTypeSystemField issueTypeField = (IssueTypeSystemField)this.getField("issuetype");
        issueTypeField.validateParams((OperationContext)this, (com.atlassian.jira.util.ErrorCollection)simpleErrorCollection, (I18nHelper)this, issue, null);
        return simpleErrorCollection;
    }

    private void setSelectedPid(Long defaultPid) {
        Collection projects;
        if (defaultPid != null) {
            this.setPid(defaultPid);
        }
        Long pid = null;
        if (this.getPid() != null) {
            pid = this.getPid();
        } else {
            Project currentProject = this.userProjectHistoryManager.getCurrentProject(11, this.getLoggedInUser());
            if (currentProject != null) {
                pid = currentProject.getId();
            }
        }
        if (pid == null && !(projects = this.permissionManager.getProjects(ProjectPermissions.CREATE_ISSUES, this.getLoggedInUser())).isEmpty()) {
            pid = ((Project)projects.iterator().next()).getId();
        }
        this.getFieldValuesHolder().put("project", pid);
        this.setPid(pid);
        this.setSelectedProjectId(pid);
    }

    private void setSelectedIssueTypeId(Project project, boolean subtask) {
        Optional lastUsedIssueTypeId = this.userIssueTypeManager.getLastUsedIssueTypeId(this.getLoggedInUser());
        String issueType = this.getIssuetype() != null ? this.getIssuetype() : (lastUsedIssueTypeId.isPresent() ? ((IssueTypeId)lastUsedIssueTypeId.get()).getId() : this.applicationProperties.getString("jira.constant.default.issue.type"));
        if (project != null) {
            Collection<String> subtaskIds = Collections2.transform(this.issueTypeSchemeManager.getSubTaskIssueTypesForProject(project), IssueTypeIdFunction.ID_FUNCTION);
            if (subtask) {
                if (!subtaskIds.contains(issueType) && !subtaskIds.isEmpty()) {
                    issueType = Iterables.get(subtaskIds, 0);
                }
            } else {
                Collection<String> issueTypeIds = Collections2.transform(this.issueTypeSchemeManager.getIssueTypesForProject(project), IssueTypeIdFunction.ID_FUNCTION);
                issueTypeIds.removeAll(subtaskIds);
                if (!issueTypeIds.contains(issueType) && !issueTypeIds.isEmpty()) {
                    IssueType defaultIssueType = this.issueTypeSchemeManager.getDefaultIssueType(project);
                    issueType = defaultIssueType != null && issueTypeIds.contains(defaultIssueType.getId()) ? defaultIssueType.getId() : Iterables.get(issueTypeIds, 0);
                }
            }
        }
        this.getFieldValuesHolder().put("issuetype", issueType);
        this.setIssuetype(issueType);
    }

    public String getFormToken() {
        return this.formToken;
    }

    public void setFormToken(String formToken) {
        this.formToken = formToken;
    }

    public String getIssuetype() {
        return this.issuetype;
    }

    public void setIssuetype(String issuetype) {
        this.issuetype = issuetype;
    }

    public Long getPid() {
        return this.pid;
    }

    public void setPid(Long pid) {
        this.pid = pid;
    }

    public Map<String, Object> getFieldValuesHolder() {
        return this.fieldValuesHolder;
    }

    public void setFieldValuesHolder(Map<String, Object> fieldValuesHolder) {
        this.fieldValuesHolder.clear();
        this.fieldValuesHolder.putAll(fieldValuesHolder);
    }

    public IssueOperation getIssueOperation() {
        return IssueOperations.CREATE_ISSUE_OPERATION;
    }

    public boolean isRetainValues() {
        return this.retainValues;
    }

    public void setRetainValues(boolean retainValues) {
        this.retainValues = retainValues;
    }

    public String[] getFieldsToRetain() {
        return this.fieldsToRetain.toArray(new String[this.fieldsToRetain.size()]);
    }

    public List<String> getFieldsToRetainAsList() {
        return this.fieldsToRetain;
    }

    public void setFieldsToRetain(String[] fieldsToRetain) {
        this.fieldsToRetain = Arrays.asList(fieldsToRetain);
    }

    public Long getParentIssueId() {
        return this.parentIssueId;
    }

    public void setParentIssueId(Long parentIssueId) {
        this.parentIssueId = parentIssueId;
    }

    public boolean isToggle() {
        return this.toggle;
    }

    public void setToggle(boolean toggle) {
        this.toggle = toggle;
    }

    public boolean isMultipleMode() {
        return this.multipleMode;
    }

    public void setMultipleMode(boolean multipleMode) {
        this.multipleMode = multipleMode;
    }

    static class IssueTypeIdFunction
    implements Function<IssueType, String> {
        public static IssueTypeIdFunction ID_FUNCTION = new IssueTypeIdFunction();

        IssueTypeIdFunction() {
        }

        @Override
        public String apply(IssueType from) {
            return from.getId();
        }
    }
}

