JIRA.Forms.CreateIssueModel=JIRA.Forms.Model.extend({DEFAULT_NON_RETAINED_FIELDS:["summary","description","timetracking","timetracking_originalestimate","timetracking_remainingestimate","worklog","worklog_startDate","worklog_timeLogged","worklog_newEstimate","worklog_adjustmentAmount","attachment"],init:function(A){A=A||{};
this.userFieldsResource=contextPath+"/rest/quickedit/1.0/userpreferences/create";
this._hasRetainFeature=true;
this._hasVisibilityFeature=true;
this.retainedFields=[];
this.initIssueType=A.issueType;
this.initProjectId=A.projectId;
this.parentIssueId=A.parentIssueId;
this.nonRetainedFields=this.DEFAULT_NON_RETAINED_FIELDS;
if(A.nonRetainedFields){this.nonRetainedFields=_.union(A.nonRetainedFields,this.DEFAULT_NON_RETAINED_FIELDS)
}},getParentIssueId:function(){return this.parentIssueId
},isInMultipleMode:function(){return this.multipleMode
},setIsMultipleMode:function(A){this.multipleMode=A
},getActiveFieldIds:function(){var A=this,B=jQuery.Deferred(),C=[];
this.getUserFields().done(function(D){jQuery.each(D,function(F,E){C.push(E)
});
A.getRequiredFields().done(function(E){jQuery.each(E,function(G,F){if(jQuery.inArray(F.id,C)===-1){C.push(F.id)
}});
B.resolve(C)
})
});
return B.promise()
},hasVisibilityFeature:function(A){return !A.required
},getFieldsResource:function(){var A=contextPath+"/secure/QuickCreateIssue!default.jspa?decorator=none";
if(this.parentIssueId){return A+"&parentIssueId="+this.parentIssueId
}if(this.initIssueType){A=A+"&issuetype="+this.initIssueType;
delete this.initIssueType
}if(this.initProjectId){A=A+"&pid="+this.initProjectId;
delete this.initProjectId
}return A
},addFieldToRetainValue:function(D,B){var A=!_.contains(this.nonRetainedFields,D);
var C=D.match(/^filetoconvert/)!==null;
if(A||C||B){this._super(D)
}},getRequiredFields:function(){var A=jQuery.Deferred(),B=[];
this.getFields().done(function(C){jQuery.each(C,function(D,E){if(E.required){B.push(E)
}});
A.resolve(B)
});
return A.promise()
},getConfigurableFields:function(){var A=jQuery.Deferred(),B=[];
this.getFields().done(function(C){jQuery.each(C,function(D,E){if(E.id!=="project"&&E.id!=="issuetype"){B.push(E)
}});
A.resolve(B)
});
return A.promise()
},getIssueSetupFields:function(){var A=jQuery.Deferred(),B=[];
this.getFields().done(function(C){jQuery.each(C,function(D,E){if(E.id==="project"||E.id==="issuetype"){B.push(E)
}});
A.resolve(B)
});
return A.promise()
}});
JIRA.Forms.CreateIssueHelper=Class.extend({init:function(A){this.form=A
},handleSubmitSuccess:function(D){function C(E,G,F){var H='<a href="'+F+'">'+E+" - "+AJS.escapeHTML(G)+"</a>";
return AJS.I18n.getText("issue.create.created",H)
}var A=this,B=this.form.$element.find("#summary").val();
D.summary=B;
this.form.triggerEvent("submitted",[D,this]);
this.form.triggerEvent("issueCreated",[D,this],true);
if(A.form.model.isInMultipleMode()){this.form.render().done(function(){var E=C(D.issueKey,B,contextPath+"/browse/"+D.issueKey);
JIRA.applySuccessMessageToForm(A.form.getForm(),E)
})
}else{this.form.triggerEvent("sessionComplete")
}},getCreateAnotherCheckbox:function(){return this.form.$element.find("#qf-create-another")
},isInMultipleMode:function(){return this.getCreateAnotherCheckbox().is(":checked")
},getProjectField:function(){return this.form.$element.find(".issue-setup-fields #project")
},getIssueTypeField:function(){return this.form.$element.find(".issue-setup-fields #issuetype")
},serializeForToggle:function(C){if(!this.form.model.hasRetainFeature()){return this.form.getForm().serialize()
}var E=this.form.model.prevActiveFields||[];
var J=this.form.getForm().serializeArray();
var D=this.form.getActiveFieldIds();
var F=jQuery.grep(J,function(K){return jQuery.inArray(K.name,D)!==-1
});
var A=jQuery.grep(E,function(K){return jQuery.inArray(K.name,D)===-1
});
var B=jQuery.map(A,function(K){return K.name
});
var H=jQuery.merge(F,A);
var G=jQuery.merge(D,B);
this.form.model.prevActiveFields=jQuery.extend(true,[],H);
if(C){G=this.executeProjectChangedSecuritySettingAction(G)
}var I=jQuery.merge([{name:"retainValues",value:true}],H);
jQuery.each(J,function(K,L){if(L.name==="pid"||L.name==="issuetype"){I.push(L)
}});
I.push({name:"toggle",value:true});
jQuery.each(G,function(K,L){I.push({name:"fieldsToRetain",value:L})
});
return jQuery.param(I)
},executeProjectChangedSecuritySettingAction:function(A){return _.reject(A,function(B){return B==="security"
})
},prepareFieldsToRetain:function(A,B){jQuery.each(A,function(C,D){B.push({name:"fieldsToRetain",value:D})
});
return B
},setIssueType:function(){var A=this,B=this.serializeForToggle();
this.form.invalidateFieldsCache();
this.form.disable();
this.form.model.refresh(B).done(function(){A.form.render();
A.form.enable()
})
},setProjectId:function(){var A=this,B=this.serializeForToggle(true);
this.form.invalidateFieldsCache();
this.form.disable();
this.form.model.refresh(B).done(function(){A.form.render();
A.form.enable()
})
},decorate:function(){var A=this;
this.getProjectField().change(function(){JIRA.trigger("dialogBeforeContentChange",["projectId",this.value,JIRA.Dialog.current.options.id]);
A.setProjectId(this.value)
});
this.getIssueTypeField().change(function(){JIRA.trigger("dialogBeforeContentChange",["issueType",this.value,JIRA.Dialog.current.options.id]);
A.setIssueType(this.value)
});
this.getCreateAnotherCheckbox().change(function(){A.form.model.setIsMultipleMode(this.checked)
})
}});
JIRA.Forms.CreateIssueError=JIRA.Forms.Error.extend({_render:function(A){return jQuery(JIRA.Templates.Issue.createIssueError({errorHtml:A,useLegacyDecorator:JIRA.useLegacyDecorator()}))
}});
JIRA.Forms.UnconfigurableCreateIssueForm=JIRA.Forms.AbstractUnconfigurableForm.extend({init:function(A){this._serialization={};
this.globalEventNamespaces=A.globalEventNamespaces||[];
this.model=A.model;
this.helper=new JIRA.Forms.CreateIssueHelper(this);
this.title=A.title;
this.action=contextPath+"/secure/QuickCreateIssue.jspa?decorator=none";
this.$element=jQuery("<div class='qf-unconfigurable-form' />")
},handleSubmitSuccess:function(A){this.helper.handleSubmitSuccess(A)
},_render:function(){var B=jQuery.Deferred(),A=this;
this.getFieldsHtml().done(function(C){A.model.getIssueSetupFields().done(function(F){var E=JIRA.Templates.Issue.createIssueForm({issueSetupFields:F,fieldsHtml:C,parentIssueId:A.model.getParentIssueId(),atlToken:A.model.getAtlToken(),title:A.title,multipleMode:A.model.isInMultipleMode(),useLegacyDecorator:JIRA.useLegacyDecorator(),showFieldConfigurationToolBar:!JIRA.Users.LoggedInUser.isAnonymous(),modifierKey:AJS.Navigator.modifierKey()}),D=JIRA.extractScripts(E);
A.$element.empty().append(D.html);
A.helper.decorate();
B.resolveWith(A,[A.$element,D.scripts])
})
});
return B.promise()
}});
JIRA.Forms.ConfigurableCreateIssueForm=JIRA.Forms.AbstractConfigurableForm.extend({init:function(A){this.model=A.model;
this.helper=new JIRA.Forms.CreateIssueHelper(this);
this.globalEventNamespaces=A.globalEventNamespaces||[];
this.issueId=A.issueId;
this.title=A.title;
this._serialization={};
this.action=contextPath+"/secure/QuickCreateIssue.jspa?decorator=none";
this.$element=jQuery("<div />").addClass("qf-form qf-configurable-form")
},handleSubmitSuccess:function(A){return this.helper.handleSubmitSuccess(A)
},_render:function(){var B=jQuery.Deferred(),A=this;
A.model.getIssueSetupFields().done(function(D){var C=JIRA.Templates.Issue.createIssueForm({issueSetupFields:D,atlToken:A.model.getAtlToken(),isConfigurable:true,title:A.title,parentIssueId:A.model.getParentIssueId(),useLegacyDecorator:JIRA.useLegacyDecorator(),multipleMode:A.model.isInMultipleMode(),showFieldConfigurationToolBar:!JIRA.Users.LoggedInUser.isAnonymous(),modifierKey:AJS.Navigator.modifierKey()});
A.$element.html(C);
A.helper.decorate();
A.renderFormContents().done(function(F,E){B.resolveWith(A,[A.$element,E])
})
});
return B.promise()
}});
JIRA.Forms.createCreateIssueForm=function(A){A=A||{};
return new JIRA.Forms.Container(function(){A.globalEventNamespaces=A.globalEventNamespaces||["QuickCreateIssue"];
var E=AJS.I18n.getText("admin.issue.operations.create"),B=new JIRA.Forms.CreateIssueModel({projectId:A.pid,issueType:A.issueType}),D=new JIRA.Forms.ConfigurableCreateIssueForm({model:B,title:E,globalEventNamespaces:A.globalEventNamespaces}),C=new JIRA.Forms.UnconfigurableCreateIssueForm({model:B,title:E,globalEventNamespaces:A.globalEventNamespaces});
return{globalEventNamespaces:A.globalEventNamespaces,model:B,errorHandler:new JIRA.Forms.CreateIssueError(),configurableForm:D,unconfigurableForm:C}
})
};
JIRA.Forms.createSubtaskForm=(function(){var A=function A(C){return C.parentIssueId||JIRA.Issue.getIssueId()||JIRA.IssueNavigator.getSelectedIssueId()
};
var B=function B(C){C=C||{};
return new JIRA.Forms.Container(function(){C.globalEventNamespaces=C.globalEventNamespaces||["QuickCreateSubtask"];
var G=A(C),H=JIRA.Dialog.getIssueActionTitle(AJS.I18n.getText("issue.create.subtask")),D=new JIRA.Forms.CreateIssueModel({parentIssueId:G,projectId:C.pid,issueType:C.issueType}),F=new JIRA.Forms.ConfigurableCreateIssueForm({model:D,title:H,globalEventNamespaces:C.globalEventNamespaces}),E=new JIRA.Forms.UnconfigurableCreateIssueForm({model:D,title:H,globalEventNamespaces:C.globalEventNamespaces});
return{globalEventNamespaces:C.globalEventNamespaces,model:D,errorHandler:new JIRA.Forms.CreateIssueError(),configurableForm:F,unconfigurableForm:E}
})
};
return B
})();
jQuery(function(){var A;
jQuery(document).on("simpleClick",".create-issue, .create-issue-type",function(E){var B=jQuery(E.target);
var D=B.is("a")?B:B.find("a");
var F=parseUri(D.attr("href")).queryKey;
var C={pid:F.pid,issueType:F.issuetype};
C=jQuery.extend(C,{pid:B.attr("data-pid"),issueType:B.attr("data-issue-type")});
JIRA.Forms.createCreateIssueForm(C).asDialog({trigger:document.createElement("a"),id:"create-issue-dialog",windowTitle:AJS.I18n.getText("admin.issue.operations.create")}).show();
E.preventDefault()
});
A=document.getElementById("stqc_show");
if(A){A.onclick=null
}jQuery(document).on("simpleClick",".issueaction-create-subtask",function(E){var B=jQuery(E.target);
var D=B.is("a")?B:B.find("a");
var C={parentIssueId:D.attr("data-issueid")};
JIRA.Forms.createSubtaskForm(C).asDialog({windowTitle:function(){return JIRA.Dialog.getIssueActionTitle(AJS.I18n.getText("issue.create.subtask"))
},trigger:document.createElement("a"),id:"create-subtask-dialog"}).show();
E.preventDefault()
})
});