/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.quickedit.rest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.quickedit.rest.api.UserPreferences;
import com.atlassian.jira.quickedit.user.UserPreferencesStore;
import com.atlassian.jira.rest.api.http.CacheControl;
import com.atlassian.jira.security.JiraAuthenticationContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Path(value="userpreferences")
public class UserPreferenceResource {
    private final JiraAuthenticationContext authenticationContext;
    private final UserPreferencesStore userPreferencesStore;

    public UserPreferenceResource(JiraAuthenticationContext authenticationContext, UserPreferencesStore userPreferencesStore) {
        this.authenticationContext = authenticationContext;
        this.userPreferencesStore = userPreferencesStore;
    }

    @GET
    @Path(value="edit")
    public Response getEditPreferences() {
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        if (loggedInUser == null) {
            return Response.ok((Object)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        return Response.ok((Object)this.userPreferencesStore.getEditUserPreferences(loggedInUser)).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="edit")
    public Response setEditPreferences(UserPreferences prefs) {
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        if (loggedInUser == null || prefs == null) {
            return Response.ok((Object)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        this.userPreferencesStore.storeEditUserPreferences(loggedInUser, prefs);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }

    @GET
    @Path(value="create")
    public Response getCreatePreferences() {
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        if (loggedInUser == null) {
            return Response.ok((Object)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        return Response.ok((Object)this.userPreferencesStore.getCreateUserPreferences(loggedInUser)).cacheControl(CacheControl.never()).build();
    }

    @POST
    @Path(value="create")
    public Response setCreatePreferences(UserPreferences prefs) {
        User loggedInUser = this.authenticationContext.getLoggedInUser();
        if (loggedInUser == null || prefs == null) {
            return Response.ok((Object)Response.Status.NOT_FOUND).cacheControl(CacheControl.never()).build();
        }
        this.userPreferencesStore.storeCreateUserPreferences(loggedInUser, prefs);
        return Response.ok().cacheControl(CacheControl.never()).build();
    }
}

