define("jira/projects/components/pinnable-navigator/manage-dialog/manage-dialog", [
    "jira/util/logger",
    "jira/projects/components/pinnable-navigator/manage-dialog/views/dialog",
    "jira/projects/libs/marionette",
    "underscore"
], function(logger, ManageDialogView, Marionette, _) {
    "use strict";

    /**
    * This will create a manage component which can be shown when user click on manage button
    * The component is initialized like this:
    *
    * var manageControl = JIRA.Projects.PinnableNavigator.ManageDialog({
    *     manageDialogView: manageDialogView
    * });
    *
    * On the initialization object:
    * @param {object} : A view object which content the template of dialog 2.
    *
    */
    var ManageDialog = Marionette.Controller.extend({

        initialize: function() {
            this.dialog = AJS.dialog2(this.options.manageDialogView.$el, {
                closeOnOutsideClick: false
            });

            this.listenTo(this.dialog, "hide", _.bind(function() {
                this.options.manageDialogView.stopLoading();
            }, this));

            this.listenTo(this.options.manageDialogView, {
                "closePopup": function () {
                    this.dialog.hide();
                },
                "itemsUpdated": function (newData) {
                    this.trigger("itemsUpdated", newData);
                }
            });

            this.dialog.on("show", _.bind(function() {
                logger.trace("jira.projects.manage.dialog.shown");
                this.trigger("manageDialogShown");
            },this));
        },

        show: function () {
            this.options.manageDialogView.render();
            this.dialog.show();
        }
    });

    /**
    * This creates a manage dialog control by creating and wiring together all the Views & Models required.
    *
    * @param {Object} options
    * ... {Object) model - Model which contain data of the view.
    * ... {String} title - The title of manage component
    * ... {String} manageText - The title of manage button and manage Diaglog
    *
    * @returns {JIRA.Projects.PinnableNavigator.ManageDialog}
    */
    ManageDialog.create = function (options) {

        var myOptions = {};
        var defaultOptions = {
            ManageDialogView: ManageDialogView
        };

        _.defaults(myOptions, options, defaultOptions);

        var manageDialogView = new myOptions.ManageDialogView({
            model: myOptions.model,
            title: myOptions.title,
            manageText: myOptions.manageText,
            emptyText: myOptions.emptyText
        });

        return new ManageDialog({
            manageDialogView: manageDialogView
        });
    };

    return ManageDialog;
});
