AJS.test.require( ['com.atlassian.jira.jira-projects-plugin:sidebar'], function() {
  'use strict';

  var sidebarInitializer = require('jira/projects/sidebar/sidebar-initializer');

  module('jira/projects/sidebar/sidebar-initializer', {
    setup: function() {
      this.sandbox = sinon.sandbox.create();
      this.fixture = document.getElementById('qunit-fixture');
    },

    teardown: function() {
      this.sandbox.restore();
    },

    mockSidebarElem: function () {
      var sidebarElemMock = document.createElement('section');
      sidebarElemMock.classList.add('aui-sidebar');
      this.fixture.appendChild(sidebarElemMock);
      return sidebarElemMock;
    },

    getSidebarElem: function () {
      return document.querySelector('.aui-sidebar');
    }
  });

  test('Sidebar should have id="sidebar" set', function () {
    var sidebarElemMock = this.mockSidebarElem();
    equal(this.getSidebarElem().id, "", 'Sidebar section should not have id="sidebar" set initially');

    sidebarInitializer.setSidebarId(sidebarElemMock);
    equal(this.getSidebarElem().id, "sidebar", 'Sidebar section should have set id="sidebar"');
  });

  test('Sidebar should have aria-label set', function () {
    var sidebarElemMock = this.mockSidebarElem();
    equal(this.getSidebarElem().getAttribute('aria-label'), null, 'Sidebar section should not have aria-label set initially');

    sidebarInitializer.setSidebarAriaLabel(sidebarElemMock);
    equal(this.getSidebarElem().getAttribute('aria-label'), "project.sidebar.label", 'Sidebar section should have aria-label set');
  });

});
