define('jira/projects/sidebar/project-shortcuts/views/list', [
    'jira/api/projects/sidebar',
    'jira/projects/sidebar/project-shortcuts/templates',
    'jira/projects/sidebar/project-shortcuts/views/shortcut',
    'jira/projects/sidebar/project-shortcuts/dialogs/add',
    'jira/projects/sidebar/component/navigation-group',
    'jira/projects/libs/marionette',
    'jquery'
], function (SidebarAPI, Templates, PSShortcutView, PSAddDialog, NavigationGroup, Marionette, $) {
    "use strict";

    return Marionette.CompositeView.extend({
        template: Templates.content,
        childView: PSShortcutView,
        ui: {
            itemsContainer: '.aui-nav',
            description: '.project-shortcuts-group__description',
            add: '.project-shortcuts-group__add'
        },
        collectionEvents: {
            /**
             * Show/hide extra description message when collection goes
             * from 0 to n items or from n to 0 items.
             */
           'add remove': function onCollectionLengthChange() {
               if (this.collection.length == 0 && this.lastCollectionLength != 0
                   || this.collection.length != 0 && this.lastCollectionLength == 0) {
                   this.lastCollectionLength = this.collection.length;
                   this.ui.description.toggleClass("hidden", this.collection.length > 0);
                   this.$el.toggleClass("project-shortcuts-group_empty", this.collection.length == 0)
               }
           }
        },
        initialize: function initialize() {
            /**
             * When sidebar is collapsed we want to hide any of the action dropdowns that
             * might be visible on the page. We do this here to attach only one event handler.
             */
            var instance = this;
            SidebarAPI.getSidebar().done(function(sidebar) {
                var auiSidebar = sidebar.getAUISidebar();
                auiSidebar.on('expand-end', function removeDuplicatedDropdownsFromTheSidebarInlineDialog () {
                    // Removing any project shortcut dropdown that could be duplicated to put inside the
                    //   inline dialog used to show the aui-sidebar-group contents when the sidebar
                    //   is collapsed.
                    $('.aui-sidebar-submenu-dialog .project-shortcuts-group__dropdown').remove();
                });
                auiSidebar.on('collapse-start', function hideDropdownOnSidebarCollapse() {
                    instance.$(".project-shortcuts-group__actions.aui-dropdown2-active").trigger("aui-button-invoke");
                });
            });

            this.lastCollectionLength = this.collection.length;
        },

        attachElContent: function(html) {
            var navigationGroup = new NavigationGroup({
                el: html
            });
            this.$el = $(navigationGroup.getElement());
            SidebarAPI.getSidebar().done(function(sidebar) {
                sidebar.replaceGroup(this.options.targetGroup, navigationGroup);
            }.bind(this));
            return this;
        },

        onRender: function onRender() {
            SidebarAPI.getSidebar().done(function(sidebar) {
                var addDialog = new PSAddDialog({
                    sidebarItem: sidebar.getGroup('project-shortcuts-group').getItem('project-shortcut-add'),
                    projectKey: this.collection.projectKey,
                    collection: this.collection
                });

                this.listenTo(addDialog, "dialog:open", function propagateOpenEvent() {
                    this.trigger("add:open");
                });
                this.listenTo(addDialog, "dialog:close", function propagateCloseEvent(isSave) {
                    this.trigger("add:close", isSave);
                });
            }.bind(this));
        },
        serializeData: function serializeData() {
            return {
                canManage: true,
                numberOfShortcuts: this.collection.length
            }
        },
        attachBuffer: function(collectionView, buffer) {
            this.ui.itemsContainer.prepend(buffer);
        },
        onAddChild: function onAddChild(childView){
            this.ui.add.parent().before(childView.$el);
        }
    });
});

AJS.namespace('JIRA.Projects.Sidebar.ProjectShortcuts.Views.List', null, require('jira/projects/sidebar/project-shortcuts/views/list'));
