define("jira/projects/summary/redirecttoissuenav", [
    "jira/api/projects",
    "wrm/context-path",
    "jquery",
    "underscore",
    "jira/projects/util/browser"
], function(ProjectsAPI, wrmContextPath, $, _, Browser) {
    "use strict";

    function sidebarIssueNavUrlForProjectKey(projectKey) {
        return wrmContextPath() + "/projects/" + encodeURIComponent(projectKey) + "/issues";
    }

    function redirectToSidebarIssueNav() {
        var currentProjectKey = ProjectsAPI.getCurrentProjectKey();
        if (currentProjectKey) {
            Browser.locationAssign(sidebarIssueNavUrlForProjectKey(currentProjectKey));
        }
    }

    return {
        start: function(selector) {
            $(selector).on("QuickCreateIssue.sessionComplete", _.bind(redirectToSidebarIssueNav, this));
        }
    };
});
