define("jira/projects/page/summary/issue/vignettes/statussummary", [
    "aui/inline-dialog",
    "jira/projects/page/summary/issue/vignettes/templates",
    "jira/projects/util/browser",
    "jira-projects-backbone",
    "jquery",
    "underscore"
], function(AuiInlineDialog, Templates, Browser, Backbone, $, _) {
    "use strict";

    var colorsToAuiClasses = {
        "blue-gray": "aui-lozenge-complete",
        "medium-gray": "",
        "yellow": "aui-lozenge-current",
        "green": "aui-lozenge-success"
    };

    var events = {
        dialogShown: "statusDialogShown",
        linkClicked: "statusLinkClicked"
    };

    var createStatusBreakdownDialogs = function(statusSummary) {
        _.each($(".status-category"), function (barSegment, index) {
            var statusBreakdownDialog = new AuiInlineDialog(barSegment, "bar-segment-" + index, function (content, trigger, showPopup) {

                var statusList = JSON.parse(barSegment.getAttribute("data-statuses"));
                var statusCategoryName = barSegment.getAttribute("data-status-category");
                var statusCategoryColor = barSegment.getAttribute("data-status-category-color");

                content.html(Templates.statusBreakdownDialog({
                    statusCategoryName: statusCategoryName,
                    statusCategoryColorClass: colorsToAuiClasses[statusCategoryColor],
                    statusList: statusList
                }));
                showPopup();
                return false;
            }, {
                onHover: true,
                width: 260,
                initCallback: function() {
                    statusSummary.trigger(events.dialogShown);
                }
            });

            statusBreakdownDialog.addClass("breakdown-dialog");
        });
    };

    var registerClickEventForStatusCategoryLinks = function(statusSummary) {
        $("#status-summary-bar-links .status-category-link").click(function(clickEvent) {
            clickEvent.preventDefault();
            var clickedStatusCategory = clickEvent.target.getAttribute("data-status-category-key");
            statusSummary.trigger(events.linkClicked, {
                statusCategory: clickedStatusCategory
            });

            var linkDestination = clickEvent.target.getAttribute("href");
            Browser.locationAssign(linkDestination);
        });
    };

    return _.extend({
        getEventNames: function() {
            return Object.keys(events).map(function(key) {
                return events[key];
            });
        },

        start: function() {
            createStatusBreakdownDialogs(this);
            registerClickEventForStatusCategoryLinks(this);
        }
    }, Backbone.Events);
});
