define("jira/projects/page/report/subnavigator", ["require"], function(require) {
    "use strict";

    var _ = require("underscore");
    var wrmData = require("wrm/data");
    var wrmContextPath = require("wrm/context-path");
    var analytics = require("jira/analytics");
    var formatter = require("jira/util/formatter");
    var reportAnalytics = require("jira/projects/page/report/analytics");
    var reportsLinkStorage = require("jira/projects/sidebar/reports/link-storage");
    var Subnavigator = require("jira/projects/components/subnavigator/subnavigator");

    function emitAnalyticsEvent(reportId, initialLoad) {
        analytics.send({
            name: "jira.project.sidebar.report.select",
            data: {
                reportId: reportId,
                initialLoad: initialLoad
            }
        });
    }

    /**
     * @param {jQuery} triggerPlaceholder
     * @param {jQuery} contentPlaceholder
     * @param {jQuery} titlePlaceholder
     * @returns {JIRA.Projects.Subnavigator}
     */
    function initReportSubnavigator(triggerPlaceholder, contentPlaceholder, titlePlaceholder) {
        var agileReports = _.map(wrmData.claim("agile-reports"), function(report) {
            return {
                id: report.key,
                label: report.label,
                description: report.description,
                link: wrmContextPath() + report.url
            };
        });

        var subnavigator = new Subnavigator({
            id: "reports",
            triggerPlaceholder: triggerPlaceholder,
            contentPlaceholder: contentPlaceholder,
            itemGroups: [agileReports, [{
                id: "com.atlassian.jira.jira-projects-plugin:report-page",
                label: formatter.I18n.getText("project.page.report.subnavigator.item.all.label"),
                description: formatter.I18n.getText("project.page.report.subnavigator.item.all.description")
            }]],
            selectedItem: "com.atlassian.jira.jira-projects-plugin:report-page",
            titlePlaceholder: titlePlaceholder,
            hideSelectedItem: true,
            changeViewText: formatter.I18n.getText("project.page.report.subnavigator.change.view")
        });
        subnavigator.on('itemSelected', function(e) {
            emitAnalyticsEvent(e.item.id, false);
        });

        subnavigator.show();

        reportAnalytics();
        emitAnalyticsEvent('com.atlassian.jira.jira-projects-plugin:report-page', true);

        reportsLinkStorage.storeLastViewedReportLink(window.location.href);

        return subnavigator;
    }

    return {
        create: initReportSubnavigator
    };
});
