AJS.test.require(['com.atlassian.jira.jira-projects-plugin:release-page-assets'], function () {
    "use strict";

    var $ = require("jquery");
    var moment = require("jira/moment");
    var Strings = require("jira/util/strings");
    var SubmitModel = require("jira/projects/release/submit-model");
    var Collection = require("jira/projects/release/pageable-versions-collection");
    var FilterModel = require("jira/projects/release/filter-model");

    var USED_NAME = "foo";
    var UNIQUE_NAME = "bar";
    var USED_NAME_WHITESPACE = "foo ";

    var CORRECT_DATE = "15/Apr/16";
    var ANOTHER_DATE = "17/May/16";
    var INCORRECT_DATE = "x15/Apr/x16";

    module('SubmitView', {
        setup: function () {
            this.context = AJS.test.mockableModuleContext();
            this.sandbox = sinon.sandbox.create({useFakeServer: true});

            Calendar._SMN= ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
            Calendar._MN= ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];

            var params = {
                ifFormat: "%e/%b/%y",
                dateFormat: "d/MMM/yy"
            };
            this.wrmData = {
                claim: sinon.stub()
            };
            this.context.mock("wrm/data", this.wrmData);
            this.wrmData.claim.withArgs('com.atlassian.jira.projects.page.release:calendarParams').returns(params);
            this.context.mock("jira/moment", moment);

            var data = [{
                name: USED_NAME
            }];
            this.pageableItems = new Collection(null, {
                data: data
            });

            this.filterModel = new FilterModel({
                pageableCollection: this.pageableItems
            });

            var SubmitView = this.context.require("jira/projects/release/submit-view");

            this.submitView = new SubmitView({
                pageableItems: this.pageableItems,
                model: new SubmitModel()
            });
            this.submitView.render();

            $('#qunit-fixture').append(this.submitView.$el);

            this.$versionName = this.submitView.$el.find('.releases-add__name');
            this.$startDate = this.submitView.$el.find('.releases-add__date-start');
            this.$releaseDate = this.submitView.$el.find('.releases-add__date-release');
            this.$description = this.submitView.$el.find('.releases-add__description');
            this.$addButton = this.submitView.$el.find('.releases-add__confirm button');

            // SingleSelect will assign to input field events after 15ms
            stop();
            setTimeout(start, 30);
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test('_getFormData() should create valid source object for SubmitModel', function () {
        this.submitView.ui.nameInput.val("name");
        this.submitView.ui.dateStartInput.val("someDateStart");
        this.submitView.ui.dateReleaseInput.val("someDateRelease");
        this.submitView.ui.descriptionInput.val("some description");

        var data = this.submitView._getFormData();

        var expected = {
            "name": "name",
            "description": "some description",
            "project": undefined,
            "releaseDate": {
                "formatted": "someDateRelease",
                "iso": ""
            },
            "startDate": {
                "formatted": "someDateStart",
                "iso": ""
            },
            "status": {
                "complete": {
                    "count": 0,
                    "jqlUrl": ""
                },
                "inProgress": {
                    "count": 0,
                    "jqlUrl": ""
                },
                "toDo": {
                    "count": 0,
                    "jqlUrl": ""
                },
                "unmapped": {
                    "count": 0,
                    "jqlUrl": ""
                }
            }
        };

        deepEqual(data, expected);

    });

    test('Should validate unique name on input', function () {
        this.$versionName.find('input').val(USED_NAME).trigger("input");
        equal(this.$versionName.find('.error').html(), "project.page.release.add.error.already.exists", "Error exists is visible");

        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");
        equal(this.$versionName.find('.error-container').html(), "", "Error is gone");
    });

    test('Should validate unique name on input regardless of case', function () {
        this.$versionName.find('input').val(USED_NAME.toUpperCase()).trigger("input");
        equal(this.$versionName.find('.error').html(), "project.page.release.add.error.already.exists", "Error exists is visible");

        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");
        equal(this.$versionName.find('.error-container').html(), "", "Error is gone");
    });

    test('Should validate unique name on input regardless of added whitespaces', function () {
        this.$versionName.find('input').val(USED_NAME_WHITESPACE).trigger("input");
        equal(this.$versionName.find('.error').html(), "project.page.release.add.error.already.exists", "Error exists is visible");

        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");
        equal(this.$versionName.find('.error-container').html(), "", "Error is gone");
    });

    test('Should validate max chars on input', function () {
        this.$versionName.find('input').val(Strings.repeat('a', 256)).trigger("input");
        equal(this.$versionName.find('.error').html(), "project.page.release.add.limit.exceeded", "Error limit exceeded is visible");

        this.$versionName.find('input').val(Strings.repeat('a', 255)).trigger("input");
        equal(this.$versionName.find('.error-container').html(), "", "Error is gone");
    });

    test('Should validate if version name already', function () {
        this.$versionName.find('input').val(USED_NAME).trigger("input");
        this.$addButton.click();

        this.$versionName.find('input').val(USED_NAME).trigger("input");
        equal(this.$versionName.find('.error').html(), "project.page.release.add.error.already.exists", "Error version already exists is visible");
        equal(this.$addButton.attr("disabled"), "disabled", "Button is disabled");

        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");
        equal(this.$versionName.find('.error-container').html(), "", "Error is gone");
        equal(this.$addButton.attr("disabled"), undefined, "Button is enabled");
    });

    test('Should disable button after render', function () {
        equal(this.submitView.$el.find('.releases-add__confirm button').attr("disabled"), "disabled", "Button is disabled");
    });

    test('Should enable button after version name is presented', function () {
        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");

        equal(this.submitView.$el.find('.releases-add__confirm button').attr("disabled"), undefined, "Button is enabled");
    });

    test('Should disable button after verion name is removed', function () {
        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");
        equal(this.submitView.$el.find('.releases-add__confirm button').attr("disabled"), undefined, "Button is enabled");

        this.$versionName.find('input').val('').trigger("input");
        equal(this.submitView.$el.find('.releases-add__confirm button').attr("disabled"), "disabled", "Button is disabled");
    });

    test('Should disable button after version was added', function () {
        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");

        equal(this.$addButton.attr("disabled"), undefined, "Button is enabled");

        this.$addButton.click();
        equal(this.$addButton.attr("disabled"), "disabled", "Button is disabled");
    });

    test('Should validate start date after losing focus', function () {
        this.$startDate.find('input').val(INCORRECT_DATE).trigger("input");
        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");

        equal(this.$startDate.find('.error').html(), "project.page.release.add.invalid.date.format", "Error exists is visible");
        equal(this.$addButton.attr("disabled"), "disabled", "Button is disabled");

        this.$startDate.find('input').val(CORRECT_DATE).trigger("input");
        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");

        equal(this.$startDate.find('.error-container').html(), "", "Error is gone");
        ok(!this.$addButton.attr("disabled"), "Button is enabled");
    });

    test('Should validate release date after losing focus', function () {
        this.$releaseDate.find('input').val(INCORRECT_DATE).trigger("input");
        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");

        equal(this.$releaseDate.find('.error').html(), "project.page.release.add.invalid.date.format", "Error exists is visible");
        equal(this.$addButton.attr("disabled"), "disabled", "Button is disabled");

        this.$releaseDate.find('input').val(CORRECT_DATE).trigger("input");
        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");

        equal(this.$releaseDate.find('.error-container').html(), "", "Error is gone");
        ok(!this.$addButton.attr("disabled"), "Button is enabled");
    });

    test('Should validate dates in incorrect order after losing focus', function () {
        this.$startDate.find('input').val(ANOTHER_DATE).trigger("input");
        this.$releaseDate.find('input').val(CORRECT_DATE).trigger("input");
        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");

        equal(this.$releaseDate.find('.error').html(), "project.page.release.add.start.release.date.order", "Error exists is visible");
        equal(this.$addButton.attr("disabled"), "disabled", "Button is disabled");

        this.$releaseDate.find('input').val(ANOTHER_DATE).trigger("input");
        this.$versionName.find('input').val(UNIQUE_NAME).trigger("input");

        equal(this.$releaseDate.find('.error-container').html(), "", "Error is gone");
        ok(!this.$addButton.attr("disabled"), "Button is enabled");
    });
});
