AJS.test.require(["com.atlassian.jira.jira-projects-plugin:release-page-assets"], function () {
    "use strict";

    var _ = require("underscore");
    var $ = require("jquery");
    var Backbone = require("backbone");
    var PageableVersionsCollection = require("jira/projects/release/pageable-versions-collection");
    var contextPath = require("wrm/context-path");

    var DummyModel = Backbone.Model.extend({});
    var DummyCollection = Backbone.Collection.extend({
        model: DummyModel
    });

    var TestPageableVersionsCollection = PageableVersionsCollection.extend({
        collectionClass: DummyCollection
    });

    var projectKey = 'TEST';

    var server;

    module('jira/projects/release/pageable-versions-collection', {
        setup: function () {
            this.stubModelDataJson = function stubModelDataJson(count) {
                return _.range(count).map(function (id) {
                    return {'id': id.toString()};
                });
            };

            server = sinon.fakeServer.create();
        },

        teardown: function () {
            server.restore();
        }
    });

    test('Should request for status data of all versions on loadProgress() and fill status field in versions table on response', function () {
        expect(7);

        var collection = new TestPageableVersionsCollection(null, {
            data: this.stubModelDataJson(5),
            projectKey: projectKey,
            cancelPreviousQuery: null
        });

        collection.originalCollection.forEach(function (version) {
            version.attributes.status = null;
        });

        var returnData = { 0: 0, 1: 1, 2: 2, 3: 3, 4: 4 };

        server.respondWith('POST', contextPath() + '/rest/projects/1.0/project/' + collection.projectKey + '/release/details/progress', [
            200, {'Content-Type': 'application/json'}, JSON.stringify(returnData)
        ]);

        collection.loadProgress(collection.originalCollection);
        server.respond();

        collection.originalCollection.forEach(function (version) {
            equal(version.attributes.status, returnData[version.attributes.id]);
        });

        equal(server.requests.length, 2);
        equal(server.requests[1].requestBody, JSON.stringify(["0", "1", "2", "3", "4"]));
    });

    test('Should fill in status field for all version for which data was in response and ignore the others on loadProgress()', function () {
        expect(7);

        var collection = new TestPageableVersionsCollection(null, {
            data: this.stubModelDataJson(5),
            projectKey: projectKey,
            cancelPreviousQuery: null
        });

        collection.originalCollection.forEach(function (version) {
            version.attributes.status = null;
        });

        var returnData = { 0: 0, 2: 2, 4: 4 };

        server.respondWith('POST', contextPath() + '/rest/projects/1.0/project/' + collection.projectKey + '/release/details/progress', [
            200, {'Content-Type': 'application/json'}, JSON.stringify(returnData)
        ]);

        collection.loadProgress(collection.originalCollection);
        server.respond();

        collection.originalCollection.forEach(function (version) {
            if (version.attributes.id in returnData) {
                equal(version.attributes.status, returnData[version.attributes.id]);
            } else {
                equal(version.attributes.status, null);
            }
        });

        equal(server.requests.length, 2);
        equal(server.requests[1].requestBody, JSON.stringify(["0", "1", "2", "3", "4"]));
    });


    test('Should do nothing on 404 result of status data request on loadProgress()', function () {
        expect(7);

        var collection = new TestPageableVersionsCollection(null, {
            data: this.stubModelDataJson(5),
            projectKey: projectKey,
            cancelPreviousQuery: null
        });

        collection.originalCollection.forEach(function (version) {
            version.attributes.status = null;
        });

        server.respondWith('POST', contextPath() + '/rest/projects/1.0/project/' + collection.projectKey + '/release/details/progress', [
            404, {'Content-Type': 'application/json'}, ''
        ]);

        collection.loadProgress(collection.originalCollection);
        server.respond();

        collection.originalCollection.forEach(function (version) {
            equal(version.attributes.status, null);
        });

        equal(server.requests.length, 2);
        equal(server.requests[1].requestBody, JSON.stringify(["0", "1", "2", "3", "4"]));
    });


    test('Should call cancelPreviousQuery if it is not null on loadProgress()', function () {
        expect(3);

        var collection = new TestPageableVersionsCollection(null, {
            data: this.stubModelDataJson(5),
            projectKey: projectKey
        });
        var cancelPreviousQueryStub = sinon.stub();
        collection.cancelPreviousQuery = cancelPreviousQueryStub;

        var returnData = {};

        server.respondWith('POST', contextPath() + '/rest/projects/1.0/project/' + collection.projectKey + '/release/details/progress', [
            200, {'Content-Type': 'application/json'}, JSON.stringify(returnData)
        ]);

        collection.loadProgress(collection.originalCollection);

        server.respond();
        equal(cancelPreviousQueryStub.callCount, 1);
        equal(server.requests.length, 2);
        equal(server.requests[1].requestBody, JSON.stringify(["0", "1", "2", "3", "4"]));
    });


    test('Should request for status data of all versions which status field is null on loadProgress()', function () {
        expect(7);

        var collection = new TestPageableVersionsCollection(null, {
            data: this.stubModelDataJson(5),
            projectKey: projectKey,
            cancelPreviousQuery: null
        });

        collection.originalCollection.forEach(function (version) {
            if (version.attributes.id % 2) {
                version.attributes.status = 1000;
            } else {
                version.attributes.status = null;
            }
        });

        var returnData = { 0: 0, 2: 2, 4: 4 };

        server.respondWith('POST', contextPath() + '/rest/projects/1.0/project/' + collection.projectKey + '/release/details/progress', [
            200, {'Content-Type': 'application/json'}, JSON.stringify(returnData)
        ]);

        collection.loadProgress(collection.originalCollection);
        server.respond()

        collection.originalCollection.forEach(function (version) {
            if (version.attributes.id % 2) {
                equal(version.attributes.status, 1000);
            } else {
                equal(version.attributes.status, returnData[version.attributes.id]);
            }
        });

        equal(server.requests.length, 2);
        equal(server.requests[1].requestBody, JSON.stringify(["0", "2", "4"]));
    });

    test('Should not send request if status field for all version is not null', function () {
        expect(6);

        var collection = new TestPageableVersionsCollection(null, {
            data: this.stubModelDataJson(5),
            projectKey: projectKey,
            cancelPreviousQuery: null
        });

        collection.originalCollection.forEach(function (version) {
            version.attributes.status = 1000;
        });

        collection.loadProgress(collection.originalCollection);
        server.respond();

        collection.originalCollection.forEach(function (version) {
            equal(version.attributes.status, 1000);
        });

        equal(server.requests.length, 1);
    });

});
