AJS.test.require(["com.atlassian.jira.jira-projects-plugin:components-page-assets"],function(){var e=require("jira/projects/libs/marionette"),c=require("jira-projects-backbone");require("jquery");var b=require("jira/projects/abstract-model/submit-model-states"),d=require("jira/jquery/deferred");module("SubmitController",{setup:function(){this.context=AJS.test.mockableModuleContext();this.sandbox=sinon.sandbox.create();this.sandbox.useFakeServer();this.clock=sinon.useFakeTimers();this.modelSave=new d;
this.modelDetails=new d;this.sandbox.stub(c.Model.prototype,"save").returns(this.modelSave);c.Model.prototype.detailsSync=this.sandbox.stub().returns(this.modelDetails);this.pageableItems={addElement:this.sandbox.stub()};_.extend(this.pageableItems,c.Events);this.featureManager={isFeatureEnabled:this.sandbox.stub()};this.flags={showErrorMsg:this.sandbox.stub()};this.context.mock("jira/featureflags/feature-manager",this.featureManager);this.context.mock("jira/projects/components/submitview",e.ItemView);
this.context.mock("jira/projects/components/submitmodel",c.Model);this.context.mock("jira/flag",this.flags);this.context.mock("jira/ajs/ajax/ajax-util",this.mockAjaxUtil());this.submitController=this.context.require("jira/projects/components/submitcontroller")},teardown:function(){this.sandbox.restore()},mockAjaxUtil:function(){return{getErrorMessageFromXHR:function(){return""}}},newSubmitView:function(){return new this.submitController({pageableItems:this.pageableItems})},mockedModel:function(){return new c.Model({name:"some name",
leadUserName:"some leadUserName",description:"some description"})}});test("SubmitView should be displayed if flag is enabled and user is admin",function(){var a=new this.submitController({isProjectAdmin:!0});ok(a.displaySubmitView())});test("SubmitView should be hidden if user is not admin",function(){var a=new this.submitController({isProjectAdmin:!1});ok(!a.displaySubmitView())});test("New element is added to pageableItems on view save event",function(){this.newSubmitView().showView().trigger("save",
this.mockedModel());ok(this.pageableItems.addElement.calledOnce)});test("componentAdd should listen to model retry-add event",function(){var a=this.newSubmitView();a.listenTo=sinon.spy();a.componentAdd(this.mockedModel());sinon.assert.calledOnce(a.listenTo);equal(a.listenTo.args[0][1],"retry-add")});test("retry-add event after componentAdd should trigger save of model as for the normal paths",function(){var a=this.newSubmitView();a._componentAdd=sinon.spy();var b=a.componentAdd(this.mockedModel());
b.trigger("retry-add");sinon.assert.calledTwice(a._componentAdd);ok(a._componentAdd.getCall(0).calledWith(b,!0));ok(a._componentAdd.getCall(1).calledWith(b,!1))});test("componentAdded should trigger change model state to SubmitModelStates.READY from SubmitModelStates.SUCCESSFUL",function(){var a=this.newSubmitView().componentAdd(this.mockedModel());equal(a.get("state"),b.IN_PROGRESS);this.modelSave.resolve();a.set("state",b.SUCCESSFUL);this.modelDetails.resolve();this.clock.tick(6E3);equal(a.get("state"),
b.READY)});test("componentAdded should NOT trigger change model state to SubmitModelStates.READY from other state than SubmitModelStates.SUCCESSFUL",function(){var a=this.newSubmitView().componentAdd(this.mockedModel());equal(a.get("state"),b.IN_PROGRESS);this.modelSave.resolve();this.modelDetails.resolve();this.clock.tick(500);a.set("state",b.ERROR_DELETE);this.clock.tick(6E3);equal(a.get("state"),b.ERROR_DELETE)})});