AJS.test.require(["com.atlassian.jira.jira-projects-plugin:abstract-list-page"],function(){var a=require("jira/projects/abstract-model/submit-model-states");require("jquery");var c=require("jira/jquery/deferred");module("SubmitModel",{setup:function(){this.context=AJS.test.mockableModuleContext();this.sandbox=sinon.sandbox.create();this.sandbox.useFakeServer();this.SubmitModel=this.context.require("jira/projects/abstract-list/submit-model");this.xhr={};this.errorResponse=[400,{"Content-Type":"application/json"},
JSON.stringify({errorMessages:[],errors:{name:"Some error"}})];this.successResponse=[200,{"Content-Type":"application/json"},JSON.stringify({some:"value",other:10})];this.detailsSyncDeferred=new c;this.model=new this.SubmitModel;this.model.toDataJSON=sinon.spy();this.detailsSyncStub=sinon.stub(this.model,"detailsSync");this.detailsSyncStub.returns(this.detailsSyncDeferred);this.model.urlRoot="/fakeUrl"},teardown:function(){this.sandbox.restore()}});test("save() should set state to SubmitModelStates.IN_PROGRESS",
function(){equal(this.model.get("state"),a.READY);this.model.save();equal(this.model.get("state"),a.IN_PROGRESS)});test("failed save() should set state to SubmitModelStates.ERROR_ADD",function(){equal(this.model.get("state"),a.READY);this.sandbox.server.respondWith(/.*\/fakeUrl.*/,this.errorResponse);this.model.save();this.sandbox.server.respond();equal(this.model.get("state"),a.ERROR_ADD)});test("success save() should resolve deferred",function(){equal(this.model.get("state"),a.READY);this.sandbox.server.respondWith(/.*\/fakeUrl.*/,
this.successResponse);var b=this.model.save();equal(b.state(),"pending");this.sandbox.server.respond();equal(b.state(),"pending");this.detailsSyncDeferred.resolve();equal(b.state(),"resolved")});test("failed save() should reject deferred",function(){equal(this.model.get("state"),a.READY);this.sandbox.server.respondWith(/.*\/fakeUrl.*/,this.errorResponse);var b=this.model.save();equal(b.state(),"pending");this.sandbox.server.respond();equal(b.state(),"rejected")});test("discard() on ERROR_ADD model should call destroy",
function(){this.model.destroy=sinon.spy();equal(this.model.get("state"),a.READY);this.model.discard();equal(this.model.get("state"),a.READY);this.model.set("state",a.ERROR_ADD);equal(this.model.get("state"),a.ERROR_ADD);sinon.assert.notCalled(this.model.destroy);this.model.discard();sinon.assert.calledOnce(this.model.destroy)});test("discard() on ERROR_DELETE model should set state to READY",function(){equal(this.model.get("state"),a.READY);this.model.discard();equal(this.model.get("state"),a.READY);
this.model.set("state",a.ERROR_DELETE);equal(this.model.get("state"),a.ERROR_DELETE);this.model.discard();equal(this.model.get("state"),a.READY)});test("discard() on ERROR_UPDATE model should set state to READY",function(){equal(this.model.get("state"),a.READY);this.model.discard();equal(this.model.get("state"),a.READY);this.model.set("state",a.ERROR_UPDATE);equal(this.model.get("state"),a.ERROR_UPDATE);this.model.discard();equal(this.model.get("state"),a.READY)})});