AJS.test.require(["com.atlassian.jira.jira-projects-plugin:abstract-list-page"], function(){
    "use strict";

    var ALFilterModel = require("jira/projects/abstract-list/filter-model");

    function getMockPageableCollection() {
        return {
            getPage: sinon.stub(),
            originalCollection: [1],
            fullCollection: {
                reset: sinon.stub()
            }
        };
    }

    module('jira/projects/abstract-list/filter-model');

    test('Should reset the collection after filter.', function () {
        var mockPageableCollection = getMockPageableCollection();
        var filterModel = new ALFilterModel({
            pageableCollection: mockPageableCollection
        });
        filterModel.filterCollection();

        sinon.assert.calledOnce(mockPageableCollection.fullCollection.reset);
        sinon.assert.calledWith(mockPageableCollection.fullCollection.reset, [1]);
    });

    test('Should set the collection to the first page after filter.', function () {
        var mockPageableCollection = getMockPageableCollection();
        var filterModel = new ALFilterModel({
            pageableCollection: mockPageableCollection
        });
        filterModel.filterCollection();

        sinon.assert.calledOnce(mockPageableCollection.getPage);
        sinon.assert.calledWith(mockPageableCollection.getPage, "first");
    });

    test('Should generate proper query string fragment based on filterAttributes', function () {
        var FilterModelWithFilterAttributes = ALFilterModel.extend({
            filterAttributes: ["test1", "test2", "test3"]
        });
        var filterModel = new FilterModelWithFilterAttributes({
            test: "test",
            test1: "test1",
            test2: "test2"
        });
        var params = filterModel.getFilterQueryStringParams();

        equal(params.indexOf("test1=test1&test2=test2"), 1, "Only listed params are in the string.");
    });

    test('Should encode values in the query string fragment', function () {
        var FilterModelWithFilterAttributes = ALFilterModel.extend({
            filterAttributes: ["test"]
        });
        var filterModel = new FilterModelWithFilterAttributes({
            test: "<a> </a>"
        });
        var params = filterModel.getFilterQueryStringParams();

        ok(params.indexOf("test=%3Ca%3E%20%3C%2Fa%3E") > -1, "Proper url escaping is applied to the values.");
    });

    test('Should encode keys in the query string fragment', function () {
        var FilterModelWithFilterAttributes = ALFilterModel.extend({
            filterAttributes: ["<a> </a>"]
        });
        var filterModel = new FilterModelWithFilterAttributes({
            "<a> </a>": "test"
        });
        var params = filterModel.getFilterQueryStringParams();

        ok(params.indexOf("%3Ca%3E%20%3C%2Fa%3E=test") > -1, "Proper url escaping is applied to the attribute names.");
    });

    test('Should trigger event when navigating', function () {
        var filterModel = new ALFilterModel({});
        var navigateStub = sinon.stub();
        filterModel.on("navigate", navigateStub);

        filterModel.navigate();

        sinon.assert.calledOnce(navigateStub);
    });
});
