/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.bc.JiraServiceContextImpl;
import com.atlassian.jira.bc.project.component.MutableProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.bc.project.component.ProjectComponentService;
import com.atlassian.jira.bc.user.search.UserSearchService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.ProjectService;
import com.atlassian.jira.projects.page.components.AssigneeSelectContextProvider;
import com.atlassian.jira.projects.util.AssigneeType;
import com.atlassian.jira.projects.util.ProjectPermissions;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.util.http.JiraUrl;
import com.atlassian.jira.web.action.ActionViewDataMappings;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.seraph.util.RedirectUtils;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Either;
import java.net.URI;
import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class ComponentEditAction
extends JiraWebActionSupport {
    private static final Logger LOG = LoggerFactory.getLogger(ComponentEditAction.class);
    private static final String FIELD_NAME = "name";
    private static final String FIELD_COMPONENT_LEAD = "componentLead";
    private static final String FIELD_ASSIGNEE_TYPE = "assigneeType";
    private static final String FIELD_DESCRIPTION = "description";
    private static final String FIELD_COMPONENT_LEAD_DISPLAYABLE_NAME = "componentLeadDisplayableName";
    private static final String FIELD_LEAD_AVATAR = "leadAvatar";
    private Long componentId;
    private final I18nHelper i18nHelper;
    private final ProjectService projectService;
    private final ProjectComponentService projectComponentService;
    private final UserSearchService userSearchService;
    private final AvatarService avatarService;
    private final ProjectPermissions projectPermissions;
    private final AssigneeSelectContextProvider assigneeSelectContextProvider;
    private final UserKeyService userKeyService;
    private String name;
    private String description;
    private String assigneeType;
    private String componentLead;
    private String decorator;
    private ProjectComponent projectComponent;
    private Project project;
    private final ImmutableMap.Builder builder;

    public ComponentEditAction(I18nHelper i18nHelper, ProjectService projectService, @ComponentImport ProjectComponentService projectComponentService, @ComponentImport UserSearchService userSearchService, @ComponentImport AvatarService avatarService, ProjectPermissions projectPermissions, AssigneeSelectContextProvider assigneeSelectContextProvider, @ComponentImport UserKeyService userKeyService) {
        this.i18nHelper = i18nHelper;
        this.projectService = projectService;
        this.projectComponentService = projectComponentService;
        this.userSearchService = userSearchService;
        this.avatarService = avatarService;
        this.projectPermissions = projectPermissions;
        this.assigneeSelectContextProvider = assigneeSelectContextProvider;
        this.userKeyService = userKeyService;
        this.builder = ImmutableMap.builder();
    }

    public String doDefault() throws Exception {
        if (this.getLoggedInUser() == null) {
            return this.getRedirect(this.getLoginUrl(), false);
        }
        if (!this.fillObjectsFromComponentId() || !this.checkPermissions()) {
            return "error";
        }
        this.fillComponentParameters();
        return super.doDefault();
    }

    private String getLoginUrl() {
        return "/login.jsp?permissionViolation=true&os_destination=" + this.getDestinationUrl(this.getHttpRequest());
    }

    private String getDestinationUrl(HttpServletRequest httpServletRequest) {
        return JiraUrlCodec.encode((String)(httpServletRequest.getServletPath() + (httpServletRequest.getPathInfo() == null ? "" : httpServletRequest.getPathInfo()) + (httpServletRequest.getQueryString() == null ? "" : "?" + httpServletRequest.getQueryString())));
    }

    private boolean fillObjectsFromComponentId() {
        this.projectComponent = this.projectComponentService.find(this.getLoggedInUser(), (ErrorCollection)this, this.getComponentId());
        if (this.hasAnyErrors()) {
            LOG.debug("Was unable to get project component.");
            return false;
        }
        Either<ErrorCollection, Project> projectEither = this.projectService.getProject(this.projectComponent.getProjectId());
        if (projectEither.isLeft()) {
            this.addErrorCollection((ErrorCollection)projectEither.left().get());
            LOG.debug("Was unable to get project.");
            return false;
        }
        this.project = (Project)projectEither.right().get();
        return true;
    }

    private boolean checkPermissions() {
        if (!this.projectPermissions.hasProjectAdminPermission(this.getLoggedInUser(), this.project).booleanValue()) {
            this.addErrorMessage(this.i18nHelper.getText("project.page.components.edit.no.permission"), ErrorCollection.Reason.FORBIDDEN);
            LOG.debug("User does not have permission to admin project.");
            return false;
        }
        return true;
    }

    private void fillComponentParameters() {
        this.setName(this.projectComponent.getName());
        this.setDescription(this.projectComponent.getDescription());
        this.setComponentLead(this.userKeyService.getUsernameForKey(this.projectComponent.getLead()));
        this.setAssigneeType(AssigneeType.valueOf(this.projectComponent.getAssigneeType()).toString());
    }

    protected String doExecute() throws Exception {
        if (this.getLoggedInUser() == null) {
            return this.getRedirect(RedirectUtils.getLoginUrl((HttpServletRequest)this.getHttpRequest()), false);
        }
        if (!this.fillObjectsFromComponentId() || !this.checkPermissions()) {
            return "error";
        }
        MutableProjectComponent mutableComponent = this.getMutableProjectComponentFromRequest();
        this.projectComponentService.update(this.getLoggedInUser(), (ErrorCollection)this, mutableComponent);
        if (this.hasAnyErrors()) {
            LOG.debug("Project update operation failed.");
            return "error";
        }
        this.builder.put((Object)"globalSuccess", (Object)this.getI18nHelper().getText("project.page.components.edit.save.success"));
        if (this.isInlineDialogMode()) {
            return this.returnComplete(this.getComponentsUrl());
        }
        return "success";
    }

    private MutableProjectComponent getMutableProjectComponentFromRequest() {
        MutableProjectComponent mutableComponent = MutableProjectComponent.copy((ProjectComponent)this.projectComponent);
        mutableComponent.setName(this.getName());
        mutableComponent.setDescription(this.getDescription());
        mutableComponent.setLead(this.userKeyService.getKeyForUsername(this.getComponentLead()));
        mutableComponent.setAssigneeType(AssigneeType.valueOf(this.getAssigneeType()).getId());
        return mutableComponent;
    }

    @ActionViewDataMappings(value={"success", "input", "error"})
    public Map<String, Object> getContextParams() {
        Map<String, Object> assigneeSelectCtx = this.assigneeSelectContextProvider.getParameters(this.project);
        this.builder.put((Object)"componentId", (Object)this.getComponentId()).put((Object)"projectComponent", this.getProjectComponentMap()).put((Object)"errors", (Object)this).putAll(assigneeSelectCtx);
        if (this.getHasErrorMessages()) {
            this.builder.put((Object)"globalErrors", (Object)this.getErrorMessages());
        }
        if (this.project != null) {
            this.builder.put((Object)"urlCancel", (Object)this.getComponentsUrl());
            this.builder.put((Object)"projectKey", (Object)this.project.getKey());
        }
        if (this.getDecorator() != null) {
            this.builder.put((Object)"decorator", (Object)this.getDecorator());
        }
        return this.builder.build();
    }

    private String getComponentsUrl() {
        return String.format("%s/projects/%s?selectedItem=com.atlassian.jira.jira-projects-plugin:components-page", JiraUrl.constructBaseUrl((HttpServletRequest)this.request), this.project.getKey());
    }

    private Map<String, Object> getProjectComponentMap() {
        return ImmutableMap.builder().put((Object)FIELD_NAME, (Object)StringUtils.defaultString((String)this.getName())).put((Object)FIELD_DESCRIPTION, (Object)StringUtils.defaultString((String)this.getDescription())).put((Object)FIELD_ASSIGNEE_TYPE, (Object)StringUtils.defaultString((String)this.getAssigneeType())).put((Object)FIELD_COMPONENT_LEAD, (Object)StringUtils.defaultString((String)this.getComponentLead())).put((Object)FIELD_COMPONENT_LEAD_DISPLAYABLE_NAME, (Object)this.getLeadName()).put((Object)FIELD_LEAD_AVATAR, (Object)this.getLeadAvatar().map(Object::toString).orElse("")).build();
    }

    private String getLeadName() {
        if (!StringUtils.isEmpty((CharSequence)this.getComponentLead())) {
            return this.getUserFullName(this.getComponentLead());
        }
        return Optional.ofNullable(this.projectComponent).map(ProjectComponent::getComponentLead).map(ApplicationUser::getDisplayName).orElse("");
    }

    private Optional<URI> getLeadAvatar() {
        if (StringUtils.isEmpty((CharSequence)this.getComponentLead())) {
            return Optional.empty();
        }
        ApplicationUser user = this.getLoggedInUser();
        return Optional.of(this.avatarService.getAvatarURL(this.getLoggedInUser(), this.userSearchService.getUserByName((JiraServiceContext)new JiraServiceContextImpl(user, (ErrorCollection)this), this.getComponentLead()), Avatar.Size.defaultSize()));
    }

    public Long getComponentId() {
        return this.componentId;
    }

    public void setComponentId(Long componentId) {
        this.componentId = componentId;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAssigneeType() {
        return this.assigneeType;
    }

    public void setAssigneeType(String assigneeType) {
        this.assigneeType = assigneeType;
    }

    public String getComponentLead() {
        return this.componentLead;
    }

    public void setComponentLead(String componentLeadUsername) {
        this.componentLead = StringUtils.lowerCase((String)componentLeadUsername);
    }

    public String getDecorator() {
        return this.decorator;
    }

    public void setDecorator(String decorator) {
        this.decorator = decorator;
    }
}

