/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class BrowseProjectContextProvider {
    private final FeatureManager featureManager;

    @Inject
    public BrowseProjectContextProvider(@ComponentImport FeatureManager featureManager) {
        this.featureManager = featureManager;
    }

    public Map<String, Object> getContext(Project project, String selected) {
        HashMap context = Maps.newHashMap();
        context.put("project", project);
        context.put("hasProjectShortcut", this.featureManager.isEnabled("rotp.project.shortcuts"));
        context.put("selected", selected);
        context.put("projectAvatarUrl", new UrlBuilder("/secure/projectavatar").addParameter("pid", (Object)project.getId()).addParameter("avatarId", (Object)project.getAvatar().getId()).addParameter("size", "large").asUrlString());
        return context;
    }
}

