/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.lastvisited;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.jira.projects.api.sidebar.lastvisited.LastVisitedNavigationItemProviderRegistry;
import com.atlassian.jira.projects.api.sidebar.navigation.NavigationItem;
import com.atlassian.jira.projects.sidebar.navigation.SidebarNavigationService;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.fugue.Option;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LastVisitedNavigationItemHelper {
    static final String SUMMARY_PAGE_KEY = "com.atlassian.jira.jira-projects-plugin:summary-page";
    static final String SUMMARY_LABEL = "Summary";
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final SidebarNavigationService sidebarNavigationService;
    private final LastVisitedNavigationItemProviderRegistry lastVisitedNavigationItemProviderRegistry;

    @Autowired
    public LastVisitedNavigationItemHelper(@ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, SidebarNavigationService sidebarNavigationService, LastVisitedNavigationItemProviderRegistry lastVisitedNavigationItemProviderRegistry) {
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.sidebarNavigationService = sidebarNavigationService;
        this.lastVisitedNavigationItemProviderRegistry = lastVisitedNavigationItemProviderRegistry;
    }

    public Optional<NavigationItem> getNavigationItemById(String navigationItemId, Project project) {
        if (SUMMARY_PAGE_KEY.equals(navigationItemId)) {
            String jiraBaseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
            String summaryPageUrl = this.fullUrlForSummaryPageWith(jiraBaseUrl, project);
            NavigationItem navItemForSummaryPage = this.buildSummaryNavigationItemWithUrl(summaryPageUrl);
            return Optional.of(navItemForSummaryPage);
        }
        Optional<NavigationItem> navigationItem = this.sidebarNavigationService.getNavigationItemById(navigationItemId, project);
        if (navigationItem.isPresent()) {
            return navigationItem;
        }
        return this.getLastVisitedItemFromProvider(project, navigationItemId);
    }

    private String fullUrlForSummaryPageWith(String baseUrl, Project project) {
        return baseUrl + "/projects/" + URLEncoder.encodePathSegment(project.getKey()) + "/summary";
    }

    private NavigationItem buildSummaryNavigationItemWithUrl(String summaryPageUrl) {
        return NavigationItem.builder().setId(SUMMARY_PAGE_KEY).setHref(summaryPageUrl).setLabel(SUMMARY_LABEL).build();
    }

    private Optional<NavigationItem> getLastVisitedItemFromProvider(Project project, String navigationItemId) {
        ProjectTypeKey projectTypeKey = project.getProjectTypeKey();
        if (projectTypeKey != null) {
            Optional provider = this.lastVisitedNavigationItemProviderRegistry.getProvider(project.getProjectTypeKey());
            return provider.flatMap(prov -> this.toOptional(prov.getNavigationItemById(project, navigationItemId)));
        }
        return Optional.empty();
    }

    private Optional toOptional(Option option) {
        return Optional.ofNullable(option.getOrNull());
    }
}

