/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.header;

import com.atlassian.jira.projects.api.sidebar.header.HeaderRenderer;
import com.atlassian.jira.projects.api.sidebar.header.HeaderRendererParameters;
import com.atlassian.jira.projects.api.sidebar.header.ScopeFilter;
import com.atlassian.jira.projects.util.TemplateRenderer;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class HeaderRendererImpl
implements HeaderRenderer {
    private static final String TEMPLATE_NAME = "JIRA.Projects.Sidebar.Header.Templates.header";
    private static final String WEB_RESOURCE_KEY = "com.atlassian.jira.jira-projects-plugin:sidebar-header-soy";
    private TemplateRenderer templateRenderer;

    @Autowired
    public HeaderRendererImpl(TemplateRenderer templateRenderer) {
        this.templateRenderer = templateRenderer;
    }

    public String render(@Nonnull HeaderRendererParameters parameters) {
        HashMap data = Maps.newHashMap();
        data.put("avatarUrl", parameters.getAvatarUrl());
        data.put("heading", parameters.getHeading());
        data.put("linkUrl", parameters.getLinkUrl());
        data.put("selected", parameters.isSelected());
        ScopeFilter scopeFilter = parameters.getScopeFilter();
        data.put("scopeFilterItems", scopeFilter.getScopeFilterItems());
        data.put("selectedItem", scopeFilter.getSelectedScopeItem());
        data.put("createNewItems", scopeFilter.getCreateNewItems());
        data.put("projectTypeKey", parameters.getProjectTypeKey());
        data.put("projectTypeIcon", parameters.getProjectTypeIcon());
        data.put("displayProjectTypeWarning", parameters.shouldDisplayProjectTypeWarning());
        data.put("isLazyLoading", parameters.isLazyLoading());
        return this.templateRenderer.render(WEB_RESOURCE_KEY, TEMPLATE_NAME, data);
    }
}

