/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.sidebar.content;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.api.context.ProjectContextPopulator;
import com.atlassian.jira.projects.api.sidebar.content.ContentRenderer;
import com.atlassian.jira.projects.api.sidebar.content.ProjectContentRenderer;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class ProjectContentRendererImpl
implements ProjectContentRenderer {
    public static final String WEB_PANEL_LOCATION = "jira.project.sidebar";
    private final ContentRenderer contentRenderer;
    private final ProjectContextPopulator contextPopulator;

    @Autowired
    public ProjectContentRendererImpl(ContentRenderer contentRenderer, ProjectContextPopulator contextPopulator) {
        this.contentRenderer = contentRenderer;
        this.contextPopulator = contextPopulator;
    }

    public String render(Project project, String selectedItemId) {
        ImmutableMap.Builder projectContext = ImmutableMap.builder();
        projectContext.put((Object)"selectedItemId", (Object)StringUtils.trimToEmpty((String)selectedItemId));
        projectContext.putAll(this.contextPopulator.populateWithProject(project));
        return this.contentRenderer.render(WEB_PANEL_LOCATION, (Map)projectContext.build());
    }
}

