/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.shortcuts;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import io.atlassian.fugue.Option;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectPermissionsHelper {
    private final PermissionManager permissionManager;

    @Autowired
    public ProjectPermissionsHelper(@ComponentImport PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public Option<String> canViewShortcuts(Project project, ApplicationUser user) {
        return this.checkPermissions(ProjectAction.VIEW_PROJECT, project, user);
    }

    public Option<String> canModifyShortcuts(Project project, ApplicationUser user) {
        return this.checkPermissions(ProjectAction.EDIT_PROJECT_CONFIG, project, user);
    }

    private Option<String> checkPermissions(ProjectAction action, Project project, ApplicationUser user) {
        if (action.hasPermission(this.permissionManager, user, project)) {
            return Option.none();
        }
        return Option.some((Object)action.getErrorKey());
    }
}

