/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.service;

import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.UserProjectHistoryManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CurrentProjectService {
    private final JiraAuthenticationContext authenticationContext;
    private final ProjectService projectService;
    private final UserProjectHistoryManager userProjectHistoryManager;

    @Autowired
    public CurrentProjectService(@ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport ProjectService projectService, @ComponentImport UserProjectHistoryManager userProjectHistoryManager) {
        this.authenticationContext = authenticationContext;
        this.projectService = projectService;
        this.userProjectHistoryManager = userProjectHistoryManager;
    }

    public void setCurrentProject(String key) {
        ApplicationUser applicationUser = this.authenticationContext.getUser();
        Project project = this.projectService.getProjectByKey(applicationUser, key).getProject();
        if (project != null) {
            this.userProjectHistoryManager.addProjectToHistory(applicationUser, project);
        }
    }
}

