/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.web.status;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.DataRequest;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status.StatusCategoryCount;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.status.StatusCategoryCountService;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.web.status.StatusCategoryCountView;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class StatusSummaryContextProvider
extends AbstractProjectsPageContextProvider {
    private final StatusCategoryCountService statusCategoryCountService;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;

    public StatusSummaryContextProvider(StatusCategoryCountService statusCategoryCountService, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, @ComponentImport JaxbJsonMarshaller jaxbJsonMarshaller) {
        this.statusCategoryCountService = (StatusCategoryCountService)Preconditions.checkNotNull((Object)statusCategoryCountService);
        this.velocityRequestContextFactory = (VelocityRequestContextFactory)Preconditions.checkNotNull((Object)velocityRequestContextFactory);
        this.jaxbJsonMarshaller = (JaxbJsonMarshaller)Preconditions.checkNotNull((Object)jaxbJsonMarshaller);
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        ImmutableMap.Builder context = ImmutableMap.builder();
        ApplicationUser currentUser = (ApplicationUser)originalContext.get("user");
        DataRequest dataRequest = new DataRequest(project, currentUser);
        List<StatusCategoryCount> statusCategoryCounts = this.statusCategoryCountService.getStatusCategoryCounts(dataRequest);
        String baseUrl = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        context.put((Object)"issueCount", (Object)this.totalNumberOfIssues(statusCategoryCounts));
        context.put((Object)"statusCategoryCounts", this.statusCategoryCountViewsOf(statusCategoryCounts));
        context.put((Object)"projectId", (Object)project.getId());
        context.put((Object)"baseUrl", (Object)baseUrl);
        return context.build();
    }

    private List<StatusCategoryCountView> statusCategoryCountViewsOf(List<StatusCategoryCount> statusCategoryCounts) {
        return (List)statusCategoryCounts.stream().map(this::toStatusCategoryCountView).collect(CollectorsUtil.toImmutableList());
    }

    private StatusCategoryCountView toStatusCategoryCountView(StatusCategoryCount statusCategoryCount) {
        String statusesAsJsonString = this.jaxbJsonMarshaller.marshal(statusCategoryCount.getStatuses());
        return new StatusCategoryCountView(statusCategoryCount.getName(), statusCategoryCount.getColor(), statusCategoryCount.getCount(), statusCategoryCount.getRoughPercentage(), statusesAsJsonString, statusCategoryCount.getKey());
    }

    private long totalNumberOfIssues(List<StatusCategoryCount> statusCategoryCounts) {
        return statusCategoryCounts.stream().mapToLong(StatusCategoryCount::getCount).sum();
    }
}

