/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.web.assignee;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.DataRequest;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.assignee.AssigneeCount;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.assignee.AssigneeCountService;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.web.assignee.AssigneeCountView;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.web.assignee.AssigneeCountViewFactory;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.rest.common.json.JaxbJsonMarshaller;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class AssigneeSummaryContextProvider
extends AbstractProjectsPageContextProvider {
    static final int MAX_DISPLAYABLE_ASSIGNEES = 5;
    private final JaxbJsonMarshaller jaxbJsonMarshaller;
    private final AssigneeCountService assigneeCountService;
    private final AssigneeCountViewFactory assigneeCountViewFactory;

    public AssigneeSummaryContextProvider(@ComponentImport JaxbJsonMarshaller jaxbJsonMarshaller, AssigneeCountService assigneeCountService, AssigneeCountViewFactory assigneeCountViewFactory) {
        this.jaxbJsonMarshaller = jaxbJsonMarshaller;
        this.assigneeCountService = assigneeCountService;
        this.assigneeCountViewFactory = assigneeCountViewFactory;
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        ImmutableMap.Builder context = ImmutableMap.builder();
        ApplicationUser loggedInUser = (ApplicationUser)originalContext.get("user");
        DataRequest dataRequest = new DataRequest(project, loggedInUser);
        List<AssigneeCount> assigneeCounts = this.assigneeCountService.getAssigneeCounts(dataRequest);
        List<AssigneeCountView> assigneeCountViews = this.assigneeCountViewFactory.getAssigneeCountViews(assigneeCounts, loggedInUser, project);
        context.put((Object)"displayableAssigneeCounts", this.getDisplayableAssignees(assigneeCountViews));
        this.populateRemainingAssigneesForContext((ImmutableMap.Builder<String, Object>)context, assigneeCountViews);
        return context.build();
    }

    private void populateRemainingAssigneesForContext(ImmutableMap.Builder<String, Object> context, List<AssigneeCountView> allAssignees) {
        List<AssigneeCountView> remainingAssignees = this.getRemainingAssignees(allAssignees);
        context.put((Object)"remainingAssigneeCountsJson", (Object)this.jaxbJsonMarshaller.marshal(remainingAssignees));
        context.put((Object)"numRemainingAssigneeCounts", (Object)remainingAssignees.size());
    }

    private List<AssigneeCountView> getDisplayableAssignees(List<AssigneeCountView> allAssignees) {
        return (List)allAssignees.stream().limit(5L).collect(CollectorsUtil.toImmutableList());
    }

    private List<AssigneeCountView> getRemainingAssignees(List<AssigneeCountView> allAssignees) {
        return (List)allAssignees.stream().skip(5L).collect(CollectorsUtil.toImmutableList());
    }
}

