/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary.issue.summary.vignettes.web.assignee;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.JqlFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.assignee.AssigneeCount;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.web.assignee.AssigneeCountView;
import com.atlassian.jira.projects.util.TemplateRenderer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named
public class AssigneeCountViewFactory {
    static final Avatar.Size AVATAR_SIZE = Avatar.Size.SMALL;
    static final String ASSIGNEE_AVATAR_TEMPLATE_WEB_RESOURCE = "com.atlassian.jira.jira-projects-plugin:summary-page-issue-vignettes-soy";
    static final String ASSIGNEE_AVATAR_TEMPLATE_NAME = "JIRA.Project.Summary.Issue.Vignette.Templates.assigneeAvatar";
    private final AvatarService avatarService;
    private final SearchService searchService;
    private final JqlFactory jqlFactory;
    private final TemplateRenderer templateRenderer;

    @Autowired
    public AssigneeCountViewFactory(@ComponentImport AvatarService avatarService, @ComponentImport SearchService searchService, JqlFactory jqlFactory, TemplateRenderer templateRenderer) {
        this.avatarService = avatarService;
        this.searchService = searchService;
        this.jqlFactory = jqlFactory;
        this.templateRenderer = templateRenderer;
    }

    public List<AssigneeCountView> getAssigneeCountViews(List<AssigneeCount> assigneeCounts, ApplicationUser loggedInUser, Project project) {
        Long totalUnresolvedIssues = this.getNumberOfUnresolvedIssues(assigneeCounts);
        return (List)assigneeCounts.stream().map(assigneeCount -> this.assigneeCountViewFrom((AssigneeCount)assigneeCount, totalUnresolvedIssues, loggedInUser, project)).collect(CollectorsUtil.toImmutableList());
    }

    private AssigneeCountView assigneeCountViewFrom(AssigneeCount assigneeCount, Long totalUnresolvedIssues, ApplicationUser loggedInUser, Project project) {
        Optional<ApplicationUser> assigneeOptional = assigneeCount.getAssignee();
        Long numIssuesForAssignee = assigneeCount.getCount();
        return new AssigneeCountView(numIssuesForAssignee, this.percentageOfTotal(numIssuesForAssignee, totalUnresolvedIssues), this.avatarHtmlForAssignee(loggedInUser, assigneeOptional, project));
    }

    private Long getNumberOfUnresolvedIssues(List<AssigneeCount> assigneeCounts) {
        return assigneeCounts.stream().mapToLong(AssigneeCount::getCount).sum();
    }

    private int percentageOfTotal(Long numIssues, Long totalNumIssues) {
        double a = numIssues.doubleValue();
        double b = totalNumIssues.doubleValue();
        return (int)Math.round(a * 100.0 / b);
    }

    private String avatarHtmlForAssignee(ApplicationUser loggedInUser, Optional<ApplicationUser> assigneeOptional, Project project) {
        return assigneeOptional.map(assignee -> this.avatarHtmlForAssignee(loggedInUser, (ApplicationUser)assignee, project)).orElse(this.avatarHtmlForUnassigned(loggedInUser, project));
    }

    private String avatarHtmlForAssignee(ApplicationUser loggedInUser, ApplicationUser assignee, Project project) {
        return this.templateRenderer.render(ASSIGNEE_AVATAR_TEMPLATE_WEB_RESOURCE, ASSIGNEE_AVATAR_TEMPLATE_NAME, (Map<String, Object>)ImmutableMap.of((Object)"assigneeDisplayName", (Object)assignee.getDisplayName(), (Object)"assigneeUserName", (Object)assignee.getUsername(), (Object)"avatarUrl", (Object)this.avatarUrlForAssignee(loggedInUser, assignee), (Object)"jqlForAssignee", (Object)this.jqlStringForAssignee(this.jqlFactory.getQueryForAllUnresolvedIssuesWithAssignee(project, assignee))));
    }

    private String avatarUrlForAssignee(ApplicationUser loggedInUser, ApplicationUser assignee) {
        return this.avatarService.getAvatarAbsoluteURL(loggedInUser, assignee, AVATAR_SIZE).toString();
    }

    private String avatarHtmlForUnassigned(ApplicationUser loggedInUser, Project project) {
        return this.templateRenderer.render(ASSIGNEE_AVATAR_TEMPLATE_WEB_RESOURCE, ASSIGNEE_AVATAR_TEMPLATE_NAME, (Map<String, Object>)ImmutableMap.of((Object)"avatarUrl", (Object)this.avatarUrlForAssignee(loggedInUser, null), (Object)"jqlForAssignee", (Object)this.jqlStringForAssignee(this.jqlFactory.getQueryForAllUnassignedAndUnresolvedIssues(project))));
    }

    private String jqlStringForAssignee(Query query) {
        return URLEncoder.encodeQueryStringValue(this.searchService.getJqlString(query));
    }
}

