/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.summary;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.page.AbstractProjectsPageContextProvider;
import com.atlassian.jira.projects.page.ProjectPanel;
import com.atlassian.jira.projects.page.ProjectWebPanelRenderer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.pagebuilder.JiraPageBuilderService;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import io.atlassian.fugue.Option;
import java.util.Map;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;

@Scanned
public class SummaryPageContextProvider
extends AbstractProjectsPageContextProvider {
    private static final String SUMMARY_PAGE_CONTEXT = "com.atlassian.jira.project.summary.page";
    private final ProjectWebPanelRenderer webPanelRenderer;
    private final PageBuilderService pageBuilderService;
    private JiraAuthenticationContext jiraAuthenticationContext;

    public SummaryPageContextProvider(ProjectWebPanelRenderer webPanelRenderer, @ComponentImport JiraPageBuilderService pageBuilderService, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext) {
        this.webPanelRenderer = webPanelRenderer;
        this.pageBuilderService = pageBuilderService;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
    }

    @Override
    protected Map<String, Object> getContextMap(Project project, Map<String, Object> originalContext) {
        this.requireSummaryPageContext();
        this.putSelectedModeInPage(originalContext);
        return this.buildContextMap(project, originalContext);
    }

    private void requireSummaryPageContext() {
        Stream.of(SUMMARY_PAGE_CONTEXT, "jira.project.sidebar").forEach(ctx -> this.pageBuilderService.assembler().resources().requireContext(ctx));
    }

    private void putSelectedModeInPage(Map<String, Object> context) {
        String mode = this.shouldRenderStatisticsAsContent(context) ? "statistics" : "activity";
        this.pageBuilderService.assembler().data().requireData("mode", mode);
    }

    private Map<String, Object> buildContextMap(Project project, Map<String, Object> originalContext) {
        return ImmutableMap.of((Object)"content", (Object)this.getRenderedSummaryPageContent(project, originalContext).getOrElse((Object)""), (Object)"title", (Object)this.getPageTitle(originalContext));
    }

    private String getPageTitle(Map<String, Object> context) {
        I18nHelper i18nHelper = this.jiraAuthenticationContext.getI18nHelper();
        return this.shouldRenderStatisticsAsContent(context) ? i18nHelper.getText("project.page.summary.subnavigator.item.statistics.label") : i18nHelper.getText("project.page.summary.subnavigator.item.activity.label");
    }

    private Option<String> getRenderedSummaryPageContent(Project project, Map<String, Object> context) {
        if (this.shouldRenderStatisticsAsContent(context)) {
            return this.webPanelRenderer.render(project, "com.atlassian.jira.jira-projects-plugin:issues-panel").map(ProjectPanel::getHtml);
        }
        return this.webPanelRenderer.render(project, "com.atlassian.jira.jira-projects-plugin:project-activity-summary").map(ProjectPanel::getHtml);
    }

    private boolean shouldRenderStatisticsAsContent(Map<String, Object> context) {
        HttpServletRequest request = (HttpServletRequest)context.get("request");
        return request != null && Boolean.parseBoolean(request.getParameter("statistics"));
    }
}

