/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.release;

import com.atlassian.jira.datetime.DateTimeFormatter;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.jql.util.JqlStringSupport;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.projects.QueryHelper;
import com.atlassian.jira.projects.URLEncoder;
import com.atlassian.jira.projects.page.release.VersionReleaseStatusView;
import com.atlassian.jira.projects.page.release.VersionView;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.query.Query;
import com.google.common.collect.ImmutableMap;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class VersionToVersionViewTransformer
implements Function<Version, VersionView> {
    private static final String VERSION_URL_TEMPLATE = "%s/browse/%s/fixforversion/%s";
    public static final String SECTION = "atl.jira.version.admin.operations";
    private final DateTimeFormatter dateTimeFormatter;
    private final VelocityRequestContextFactory velocityRequestContextFactory;
    private final VersionManager versionManager;
    private final QueryHelper queryHelper;
    private final DynamicWebInterfaceManager dynamicWebInterfaceManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final JqlStringSupport jqlStringSupport;

    @Autowired
    public VersionToVersionViewTransformer(@ComponentImport DateTimeFormatter dateTimeFormatter, @ComponentImport VelocityRequestContextFactory velocityRequestContextFactory, QueryHelper queryHelper, @ComponentImport DynamicWebInterfaceManager dynamicWebInterfaceManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, VersionManager versionManager, @ComponentImport JqlStringSupport jqlStringSupport) {
        this.dateTimeFormatter = dateTimeFormatter;
        this.velocityRequestContextFactory = velocityRequestContextFactory;
        this.versionManager = versionManager;
        this.queryHelper = queryHelper;
        this.dynamicWebInterfaceManager = dynamicWebInterfaceManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.jqlStringSupport = jqlStringSupport;
    }

    private VersionView.Date getDate(Date date) {
        if (date == null) {
            return new VersionView.Date("", "", "");
        }
        Locale userLocale = this.jiraAuthenticationContext.getLocale();
        return new VersionView.Date(this.dateTimeFormatter.withLocale(userLocale).withStyle(DateTimeStyle.DATE).format(date), this.dateTimeFormatter.withLocale(userLocale).withStyle(DateTimeStyle.ISO_8601_DATE).format(date), this.dateTimeFormatter.withLocale(userLocale).withStyle(DateTimeStyle.DATE_PICKER).format(date));
    }

    private VersionReleaseStatusView.StatusEntry getIssueCountAndJqlUrl(String projectAndVersionLink, JqlClauseBuilder jqlForStatusCategoryBuilder, String statusCategory) {
        Query statusQuery = jqlForStatusCategoryBuilder.and().statusCategory(new String[]{statusCategory}).buildQuery();
        return new VersionReleaseStatusView.StatusEntry(this.queryHelper.countIssues(statusQuery), this.getJqlForStatusCategory(projectAndVersionLink, statusCategory));
    }

    private String buildProjectAndVersionJql(String projectKey, String versionName) {
        String context = this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl();
        StringBuilder sb = new StringBuilder(100);
        sb.append(context).append("/issues/?jql=project+%3D+").append(this.jqlStringSupport.encodeStringValue(projectKey)).append("+AND+fixVersion+%3D+").append(this.jqlStringSupport.encodeStringValue(versionName));
        return sb.toString();
    }

    private String getJqlForStatusCategory(String projectAndVersionQuery, String statusCategory) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(projectAndVersionQuery).append("+AND+statusCategory+%3D+").append(this.jqlStringSupport.encodeStringValue(statusCategory));
        return sb.toString();
    }

    VersionReleaseStatusView getStatus(Version version) {
        String jqlForProjectAndVersion = this.buildProjectAndVersionJql(version.getProject().getKey(), version.getName());
        return new VersionReleaseStatusView(this.getIssueCountAndJqlUrl(jqlForProjectAndVersion, this.buildProjectAndVersionJqlClause(version), "undefined"), this.getIssueCountAndJqlUrl(jqlForProjectAndVersion, this.buildProjectAndVersionJqlClause(version), "new"), this.getIssueCountAndJqlUrl(jqlForProjectAndVersion, this.buildProjectAndVersionJqlClause(version), "indeterminate"), this.getIssueCountAndJqlUrl(jqlForProjectAndVersion, this.buildProjectAndVersionJqlClause(version), "done"));
    }

    private JqlClauseBuilder buildProjectAndVersionJqlClause(Version version) {
        return JqlQueryBuilder.newBuilder().where().project(new Long[]{version.getProjectObject().getId()}).and().fixVersion(version.getId());
    }

    private List<VersionView.Operation> getOperations(Version version) {
        return StreamSupport.stream(this.dynamicWebInterfaceManager.getDisplayableWebItems(SECTION, (Map)ImmutableMap.of((Object)"version", (Object)version, (Object)"user", (Object)this.jiraAuthenticationContext.getLoggedInUser(), (Object)"project", (Object)version.getProject(), (Object)"helper", (Object)new JiraHelper(null, version.getProject()))).spliterator(), false).map(webItem -> new VersionView.Operation(webItem.getUrl(), webItem.getStyleClass(), webItem.getLabel())).collect(Collectors.toList());
    }

    public VersionView getView(Version version) {
        return this.getView(version, true);
    }

    public VersionView getView(Version version, boolean shouldGetStatus) {
        String versionUrl = String.format(VERSION_URL_TEMPLATE, this.velocityRequestContextFactory.getJiraVelocityRequestContext().getBaseUrl(), URLEncoder.encodePathSegment(version.getProjectObject().getKey()), version.getId());
        VersionReleaseStatusView statusView = null;
        if (shouldGetStatus) {
            statusView = this.getStatus(version);
        }
        return new VersionView(version, versionUrl, statusView, this.getDate(version.getStartDate()), this.getDate(version.getReleaseDate()), this.versionManager.isVersionOverDue(version), this.getOperations(version));
    }

    @Override
    public VersionView apply(Version input) {
        return this.getView(input, true);
    }
}

