/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.page.components;

import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.userformat.UserFormats;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.projects.QueryHelper;
import com.atlassian.jira.projects.page.components.ComponentView;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.Query;
import com.google.common.base.Function;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ComponentToComponentViewTransformer {
    private static final String PROFILE_LINK_USER_FORMAT_TYPE = "profileLinkWithAvatar";
    private final QueryHelper queryHelper;
    private final UserFormats userFormats;

    @Autowired
    public ComponentToComponentViewTransformer(QueryHelper queryHelper, @ComponentImport UserFormats userFormats) {
        this.queryHelper = queryHelper;
        this.userFormats = userFormats;
    }

    public Function<ProjectComponent, ComponentView> componentToComponentView(Project project) {
        return projectComponent -> {
            Query projectAndComponentQuery = JqlQueryBuilder.newBuilder().where().project(new String[]{project.getKey()}).and().component(new String[]{projectComponent.getName()}).buildQuery();
            ApplicationUser componentLead = projectComponent.getComponentLead();
            String leadName = "";
            String userProfileLinkHtml = "";
            if (componentLead != null) {
                leadName = componentLead.getDisplayName();
                userProfileLinkHtml = this.userFormats.formatter(PROFILE_LINK_USER_FORMAT_TYPE).formatUsername(componentLead.getUsername(), "components");
            }
            return new ComponentView((ProjectComponent)projectComponent, leadName, userProfileLinkHtml, this.queryHelper.countIssues(projectAndComponentQuery), this.queryHelper.buildURL(projectAndComponentQuery), project.getKey());
        };
    }
}

