/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.versionpanel.fragment.impl;

import com.atlassian.jira.plugin.versionpanel.BrowseVersionContext;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.projects.legacy.versionpanel.VersionTabPanelFragment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.web.util.OutlookDate;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang.StringUtils;

@Named
public class VersionDescriptionFragment
extends AbstractFragment
implements VersionTabPanelFragment {
    private static final String TEMPLATE_DIRECTORY_PATH = "legacy/templates/versionpanels/fragments/summary/";

    @Inject
    public VersionDescriptionFragment(@ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext) {
        super(templatingEngine, jiraAuthenticationContext);
    }

    @Override
    public String getId() {
        return "versiondescription";
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        try {
            Version version = ((BrowseVersionContext)ctx).getVersion();
            return !StringUtils.isBlank((String)version.getDescription()) || version.getReleaseDate() != null;
        }
        catch (ClassCastException e) {
            log.error("The supplied context must be of type BrowseVersionContext", (Throwable)e);
            throw new IllegalStateException("The supplied context must be of type BrowseVersionContext", e);
        }
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("SFM_HIDE", OutlookDate.SmartFormatterModes.HIDE_TIME);
        return velocityParams;
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }
}

