/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlOrderByBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.ProjectTabPanelFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractUnresolvedIssuesFragment;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractUrlFragmentUtil;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.JqlFactory;
import com.atlassian.jira.projects.page.summary.issue.summary.vignettes.service.StatisticAccessorBeanFactory;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.jira.web.bean.StatisticMapWrapper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.order.OrderBy;
import com.atlassian.query.order.SortOrder;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public class UnresolvedIssuesByPriorityFragment
extends AbstractUnresolvedIssuesFragment
implements ProjectTabPanelFragment {
    private static final Logger log = LoggerFactory.getLogger(UnresolvedIssuesByPriorityFragment.class);
    private final ApplicationProperties applicationProperties;

    @Inject
    public UnresolvedIssuesByPriorityFragment(@ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport ApplicationProperties applicationProperties, @ComponentImport JiraAuthenticationContext authenticationContext, @ComponentImport FieldVisibilityManager fieldVisibilityManager, StatisticAccessorBeanFactory accessorBeanFactory, JqlFactory jqlFactory) {
        super(templatingEngine, authenticationContext, fieldVisibilityManager, accessorBeanFactory, jqlFactory);
        this.applicationProperties = applicationProperties;
    }

    @Override
    public String getId() {
        return "unresolvedissuesbypriority";
    }

    @Override
    String getIssueFieldConstant() {
        return "priority";
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("priorities", this.getPriorities(ctx));
        velocityParams.put("urlUtil", new PriorityUrlUtil(this.getSearchRequest(ctx), this.authenticationContext.getLoggedInUser(), this.applicationProperties));
        return velocityParams;
    }

    StatisticMapWrapper getPriorities(BrowseContext ctx) {
        try {
            StatisticMapWrapper map = this.getStatsBean(ctx).getAllFilterBy("priorities");
            this.transformStatisticMapWrapper(map);
            return map;
        }
        catch (SearchException e) {
            log.error("Could not search for priorities in project '{}'", (Object)ctx.getProject().getKey(), (Object)e);
            return null;
        }
    }

    private void transformStatisticMapWrapper(StatisticMapWrapper map) {
        LinkedHashMap<Priority, Integer> priorityMap = new LinkedHashMap<Priority, Integer>(map.size());
        for (Object o : map.entrySet()) {
            Map.Entry entry = (Map.Entry)o;
            Priority priority = (Priority)entry.getKey();
            priorityMap.put(priority, (Integer)entry.getValue());
        }
        map.setStatistics(priorityMap);
    }

    public static class PriorityUrlUtil
    extends AbstractUrlFragmentUtil<Priority> {
        public PriorityUrlUtil(SearchRequest searchRequest, ApplicationUser user, ApplicationProperties applicationProperties) {
            super(searchRequest, user, applicationProperties);
        }

        @Override
        protected Clause getDomainClause(Priority priority) {
            JqlClauseBuilder builder = JqlQueryBuilder.newClauseBuilder();
            builder.priority().eq(priority.getName());
            return builder.buildClause();
        }

        @Override
        protected OrderBy getOrderBy() {
            JqlOrderByBuilder jqlOrderByBuilder = JqlQueryBuilder.newOrderByBuilder();
            jqlOrderByBuilder.priority(SortOrder.DESC);
            return jqlOrderByBuilder.buildOrderBy();
        }
    }
}

