/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.gadgets.view.GadgetViewFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractFragment;
import com.atlassian.jira.projects.util.TemplateRenderer;
import com.atlassian.jira.projects.util.WebPanelRenderer;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.util.JiraUrlCodec;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class ActivityStreamFragment
extends AbstractFragment {
    protected static final String TEMPLATE_DIRECTORY_PATH = "legacy/templates/projectpanels/fragments/summary/";
    private static final String ACTIVTY_STREAM_GADGET_MODULE_KEY = "com.atlassian.streams.streams-jira-plugin:activitystream-gadget";
    private static final String SUMMARY_PAGE_SOY_TEMPLATE_KEY = "com.atlassian.jira.jira-projects-plugin:project-subpages-soy";
    private static final String WEB_PANEL_LOCATION = "webpanels.browse.project.summary.activitystream";
    private static final String INLINE_ACTIVITY_STREAM_FEATURE_KEY = "com.atlassian.streams.InlineActivityStream";
    private final PluginAccessor pluginAccessor;
    private final WebPanelRenderer webPanelRenderer;
    private final FeatureManager featureManager;
    private final TemplateRenderer templateRenderer;

    @Inject
    public ActivityStreamFragment(@ComponentImport VelocityTemplatingEngine templatingEngine, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport PluginAccessor pluginAccessor, WebPanelRenderer webPanelRenderer, @ComponentImport FeatureManager featureManager, TemplateRenderer templateRenderer) {
        super(templatingEngine, jiraAuthenticationContext);
        this.pluginAccessor = pluginAccessor;
        this.webPanelRenderer = webPanelRenderer;
        this.featureManager = featureManager;
        this.templateRenderer = templateRenderer;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> params = super.createVelocityParams(ctx);
        String projectKey = ctx.getProject().getKey();
        params.put("gadgetHtml", this.getPanelHtml(projectKey));
        return params;
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    public String getId() {
        return "activitystream";
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        GadgetViewFactory viewFactory = (GadgetViewFactory)ComponentAccessor.getOSGiComponentInstanceOfType(GadgetViewFactory.class);
        return viewFactory != null && this.pluginAccessor.isPluginModuleEnabled(ACTIVTY_STREAM_GADGET_MODULE_KEY) && this.getIssueCountInSearch(ctx) > 0L;
    }

    public String getPanelHtml(String projectKey) {
        String html;
        ImmutableMap.Builder context = ImmutableMap.builder();
        if (this.featureManager.isEnabled(INLINE_ACTIVITY_STREAM_FEATURE_KEY)) {
            String url = this.getRequestContextPath() + "/activity?maxResults=10&streams=key+IS+" + this.getJiraUrlEncoded(projectKey);
            context.put((Object)"url", (Object)url);
            html = this.templateRenderer.render(SUMMARY_PAGE_SOY_TEMPLATE_KEY, "JIRA.Project.Summary.Templates.inlineActivityStream", (Map<String, Object>)context.build());
        } else {
            context.put((Object)"projectKey", (Object)projectKey);
            html = (String)this.webPanelRenderer.renderWebPanels(WEB_PANEL_LOCATION, (Map<String, Object>)context.build()).getOrElse((Object)"");
        }
        return html;
    }

    @VisibleForTesting
    String getRequestContextPath() {
        return ExecutingHttpRequest.get().getContextPath();
    }

    @VisibleForTesting
    String getJiraUrlEncoded(String projectKey) {
        return JiraUrlCodec.encode((String)projectKey);
    }
}

