/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.fragment.impl;

import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.datetime.DateTimeStyle;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchRequest;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.views.util.SearchRequestViewUtils;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.projects.legacy.projectpanel.fragment.impl.AbstractMultiFragment;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.template.VelocityTemplatingEngine;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.jira.web.util.OutlookDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractIssuesFragment
extends AbstractMultiFragment {
    private static final Logger log = LoggerFactory.getLogger(AbstractIssuesFragment.class);
    protected static final String TEMPLATE_DIRECTORY_PATH = "legacy/templates/projectpanels/fragments/summary/";
    private static final Integer DEFAULT_DISPLAY_ISSUE_COUNT = 3;
    private final SearchService searchService;
    private final ApplicationProperties applicationProperties;
    private final DateTimeFormatterFactory dateTimeFormatterFactory;

    public AbstractIssuesFragment(JiraAuthenticationContext jiraAuthenticationContext, VelocityTemplatingEngine templatingEngine, SearchService searchService, ApplicationProperties applicationProperties, DateTimeFormatterFactory dateTimeFormatterFactory) {
        super(templatingEngine, jiraAuthenticationContext);
        this.searchService = searchService;
        this.applicationProperties = applicationProperties;
        this.dateTimeFormatterFactory = dateTimeFormatterFactory;
    }

    @Override
    protected String getTemplateDirectoryPath() {
        return TEMPLATE_DIRECTORY_PATH;
    }

    @Override
    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Map<String, Object> velocityParams = super.createVelocityParams(ctx);
        velocityParams.put("issues", this.getIssues(ctx));
        velocityParams.put("srUrl", this.createSearchRequestUrl(this.getSearchRequest(ctx)));
        velocityParams.put("relativeDateTimeFormatter", this.dateTimeFormatterFactory.formatter().withStyle(DateTimeStyle.RELATIVE_WITH_TIME_ONLY).forLoggedInUser());
        velocityParams.put("SFM_HIDE", OutlookDate.SmartFormatterModes.HIDE_TIME);
        return velocityParams;
    }

    @Override
    public boolean showFragment(BrowseContext ctx) {
        return this.getDisplayIssueCount() > 0 && this.getIssueCountInSearch(ctx) > 0L;
    }

    Integer getDisplayIssueCount() {
        String displayIssueCount = this.applicationProperties.getDefaultBackedString("jira.project.summary.max.issues");
        try {
            if (displayIssueCount == null) {
                return DEFAULT_DISPLAY_ISSUE_COUNT;
            }
            Integer intDisplayIssueCount = Integer.valueOf(displayIssueCount);
            if (intDisplayIssueCount < 0) {
                return DEFAULT_DISPLAY_ISSUE_COUNT;
            }
            return intDisplayIssueCount;
        }
        catch (NumberFormatException e) {
            log.warn("Invalid value for application property '{}': {}", (Object)"jira.project.summary.max.issues", (Object)displayIssueCount);
            return DEFAULT_DISPLAY_ISSUE_COUNT;
        }
    }

    List<Issue> getIssues(BrowseContext ctx) {
        try {
            SearchRequest sr = this.getSearchRequest(ctx);
            PagerFilter pagerFilter = new PagerFilter(this.getDisplayIssueCount().intValue());
            SearchResults results = this.searchService.search(this.authenticationContext.getLoggedInUser(), sr.getQuery(), pagerFilter);
            if (results != null && results.getResults() != null) {
                return results.getResults();
            }
        }
        catch (SearchException e) {
            log.warn("Could not complete the search request", (Throwable)e);
        }
        return new ArrayList<Issue>();
    }

    abstract SearchRequest getSearchRequest(BrowseContext var1);

    private String createSearchRequestUrl(SearchRequest sr) {
        VelocityRequestContext velocityRequestContext = new DefaultVelocityRequestContextFactory(this.applicationProperties).getJiraVelocityRequestContext();
        StringBuilder link = new StringBuilder();
        link.append(SearchRequestViewUtils.getLink((SearchRequest)sr, (String)velocityRequestContext.getBaseUrl(), (ApplicationUser)this.authenticationContext.getLoggedInUser())).append("&mode=hide");
        return link.toString();
    }
}

