AJS.test.require("com.atlassian.jira.jira-projects-plugin:browseproject", function() {

    module("Util.selectedTab");

    test("sets the selected tab in the query string of the specified url", function () {
        var url = "http://jira.address/context/browse/PROJ/?selectedTab=old-tab:value";
        var selectedTabValue = "new-tab:value";
        var result = JIRA.Projects.Util.setSelectedTab(url, selectedTabValue);
        equal(result, "?selectedTab=new-tab:value");
    });

    test("sets the selected tab in the query string when there is no query string", function () {
        var url = "http://jira.address/context/browse/PROJ/";
        var selectedTabValue = "new-tab-value";
        var result = JIRA.Projects.Util.setSelectedTab(url, selectedTabValue);
        equal(result, "?selectedTab=new-tab-value");
    });

    test("sets the selected tab in the query string when there is an empty query string", function () {
        var url = "http://jira.address/context/browse/PROJ/?";
        var selectedTabValue = "new-tab-value";
        var result = JIRA.Projects.Util.setSelectedTab(url, selectedTabValue);
        equal(result, "?selectedTab=new-tab-value");
    });

    test("sets the selected tab in the query string preserving values to the right", function () {
        var url = "http://jira.address/context/browse/PROJ/?selectedTab=old-tab-value&id=123";
        var selectedTabValue = "new-tab-value";
        var result = JIRA.Projects.Util.setSelectedTab(url, selectedTabValue);
        equal(result, "?selectedTab=new-tab-value&id=123");
    });

    test("sets the selected tab in the query string preserving values to the left", function () {
        var url = "http://jira.address/context/browse/PROJ/?id=123&selectedTab=old-tab-value";
        var selectedTabValue = "new-tab-value";
        var result = JIRA.Projects.Util.setSelectedTab(url, selectedTabValue);
        equal(result, "?id=123&selectedTab=new-tab-value");
    });

    test("extracts selected tab from browse project url", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/?selectedTab=the.current.tab";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), "the.current.tab");
    });

    test("selected tab is null when query parameter has no equals or value", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/?selectedTab";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), null);
    });

    test("last value is taken when selectedTab appears multiple times", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/?selectedTab=first.value&selectedTab=second.value";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), "second.value");
    });

    test("extracts selected tab when there are other query string values after", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/?selectedTab=the.current.tab&id=1";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), "the.current.tab");
    });

    test("extracts selected tab when there is a parameter with value selectedTab", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/?foo=selectedTab&selectedTab=the.current.tab";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), "the.current.tab");
    });

    test("returns null when selected tab is not present", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/?id=1";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), null);
    });

    test("returns null when there is no query string", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), null);
    });

    test("extracts selected tab when it is the last string value", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/?precedingKey=precedingValue&selectedTab=the.current.tab";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), "the.current.tab");
    });

    test("extracts selected tab when it is between two other querystring parameters", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/?precedingKey=precedingValue&selectedTab=the.current.tab&followingKey=followingValue";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), "the.current.tab");
    });

    test("returns null when the key is present in the query string with no value", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/?selectedTab=";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), null);
    });

    test("returns null when the key is present in the query string with no value and has another value following", function () {
        var tabLinkHref = "http://jira.address/context/browse/PROJ/?selectedTab=&id=1";
        equal(JIRA.Projects.Util.extractSelectedTab(tabLinkHref), null);
    });
});