AJS.test.require("com.atlassian.jira.jira-projects-plugin:browseproject", function() {

    module("TabPanelRouter", {
        setup: function() {
            this.sandbox = sinon.sandbox.create();
        },
        teardown: function() {
            this.sandbox.restore();
        }
    });

    test("identifies and reports requested tab from url", function () {
        var pathname = "foo/browse/SALES",
            search = "?selectedTab=my.plugin.tab";

        var tabModel = new JIRA.Projects.TabModel();
        this.sandbox.stub(tabModel, "newTabRequested");

        new JIRA.Projects.TabPanelRouter(tabModel, {pathname: pathname, search: search});

        Backbone.history.loadUrl(pathname + search, true);

        ok(tabModel.newTabRequested.calledOnce, "switches tabs on url load");
        ok(tabModel.newTabRequested.calledWithExactly(pathname + search), "Correctly reports requested tab");
    });

    test("identifies and reports requested tab from legacy url", function () {
        var pathName = "j/secure/BrowseProject.jspa#selectedTab=my.plugin:tab",
            search = "?id=123&selectedTab=my.plugin:tab";

        var tabModel = new JIRA.Projects.TabModel();
        this.sandbox.stub(tabModel, "newTabRequested");

        new JIRA.Projects.TabPanelRouter(tabModel, {pathname: pathName, search: search});

        Backbone.history.loadUrl(pathName + search, true);

        ok(tabModel.newTabRequested.calledOnce, "switches tabs on legacy url load");
        ok(tabModel.newTabRequested.calledWithExactly(pathName + search), "Reports path to requested tab");
    });

    test("redirects old system tabs to the tabs in this plugin", function () {
        var pathname = "foo/browse/SALES",
            search = "?selectedTab=com.atlassian.jira.plugin.system.project:tab",
            redirectedSearch = "?selectedTab=com.atlassian.jira.jira-projects-plugin:tab";

        var tabModel = new JIRA.Projects.TabModel();
        this.sandbox.stub(tabModel, 'newTabRequested');

        new JIRA.Projects.TabPanelRouter(tabModel, {pathname: pathname, search: search});

        Backbone.history.loadUrl(pathname + search, true);

        ok(tabModel.newTabRequested.calledOnce, "loads tab when legacy tab requested");
        ok(tabModel.newTabRequested.calledWith(pathname + redirectedSearch), "Reports path with new selected tab path");
    });

});
