AJS.test.require("com.atlassian.jira.jira-projects-plugin:browseproject",function(){module("JIRA.Projects.TabModel",{setup:function(){this.sandbox=sinon.sandbox.create();this.server=this.sandbox.useFakeServer()},teardown:function(){this.sandbox.restore()}});test("fetches when new tab requested",function(){var a=new JIRA.Projects.TabModel();sinon.stub(a,"fetch");a.newTabRequested("/our/url");equal(a.fetch.callCount,1)});test("points to url of undecorated target tab",function(){var a=new JIRA.Projects.TabModel();a.newTabRequested("/bob?selectedTab=foo");equal(a.url(),"/bob?selectedTab=foo&decorator=none&contentOnly=true")});test("always requests data in plain-text",function(){var a=new JIRA.Projects.TabModel();sinon.stub(a,"fetch");a.newTabRequested("/bob?selectedTab=foo");equal(typeof a.fetch.getCall(0).args[0],"object");equal(a.fetch.getCall(0).args[0].dataType,"text","should always request text")});test("sets html attribute on fetch",function(){var a=new JIRA.Projects.TabModel();a.newTabRequested();ok(!a.has("html"),"won't be set yet because we haven't attempted to fetch");equal(this.server.requests.length,1);this.server.requests[0].respond();ok(a.has("html"),"should have gotten set after fetch")});test("html attribute empty when no data given",function(){var a=new JIRA.Projects.TabModel();a.newTabRequested();this.server.requests[0].respond();equal(a.get("html"),"")});test("html attribute set to response",function(){var b='<div class="foo">yo</div>';var a=new JIRA.Projects.TabModel();a.newTabRequested();this.server.requests[0].respond(200,{"Content-Type":"text/html"},b);equal(a.get("html"),b)});test("triggers switch event on successful fetch",function(){var c='<div class="foo">yo</div>';var b=new JIRA.Projects.TabModel();var d=sinon.spy();var a="/bob";b.on("switch",d);b.newTabRequested(a);this.server.requests[0].respond(200,{"Content-Type":"text/html"},c);equal(d.callCount,1);ok(d.calledWithExactly(a),"should be passed the url that was retrieved")});test("triggers error event if HTTP headers indicate user is not logged in",function(){var e='<div class="foo">yo</div>';var d=new JIRA.Projects.TabModel();var a=sinon.spy(),b=sinon.spy(),c="/bob";d.on("switch",a);d.on("switch-error",b);d.newTabRequested(c);this.server.requests[0].respond(200,{"Content-Type":"text/html","X-Atlassian-Dialog-Control":"permissionviolation"},e);equal(a.callCount,0,"Permission violation should not trigger a tab switched event");ok(b.calledOnce,"Permission violation should an error event");ok(b.calledWithExactly({loggedOut:true},c),"Permission violation event should indicate logged out status with return url");var f=b.getCall(0).args[0];equal(typeof f,"object");ok(f.loggedOut,"should indicate user is logged out")});test("triggers error event on non-200 response",function(){var e='<div class="foo">yo</div>';var d=new JIRA.Projects.TabModel();var a=sinon.spy(),b=sinon.spy(),c="/bob";d.on("switch",a);d.on("switch-error",b);d.newTabRequested(c);this.server.requests[0].respond(404,{"Content-Type":"text/html"},e);ok(!a.called,"should not switch tabs if there is an error");ok(b.calledOnce,"should raise error event on non-200 response");equal(b.getCall(0).args[1],c,"should be passed the url that was retrieved")})});