AJS.namespace("JIRA.Projects");

JIRA.Projects.TabLoader = {

    init: function ($el, history, location, pushState) {

        var tab = new JIRA.Projects.TabModel();

        tab.on("switch", function (url) {
            var newTabKey = JIRA.Projects.Util.extractSelectedTab(url);
            var newTabQueryString = JIRA.Projects.Util.setSelectedTab(location.href, newTabKey);
            history.navigate(newTabQueryString, false);
        });

        tab.on("switch-error", function (response, target) {
            var msg = JIRA.Messages.showErrorMsg;

            if (response.loggedOut) {
                var login = AJS.contextPath() + "/login.jsp?permissionViolation=true&os_destination=" + target;
                return location.replace(login);
            } else if (response.statusText === "timeout") {
                msg(JIRA.Projects.ErrorMessages.timeout());
            } else if (response.status === 404) {
                msg(JIRA.Projects.ErrorMessages.notFound());
            } else {
                msg(JIRA.Projects.ErrorMessages.genericError());
            }
        });

        new JIRA.Projects.TabView({
            model: tab,
            el: $el
        });

        new JIRA.Projects.TabPanelRouter(tab, location);
        var hasFragment = location.href.indexOf("#") > -1;

        history.start({
            pushState: pushState,
            hashChange: !pushState,
            silent: !hasFragment,
            root: location.pathname
        });

        // Put the tab selection into the url if it isn't there already, so we can get back to it with the 'Back' button
        // We need to update the url if there is no selected tab in the url, or we don't have push state and there's no fragment
        if (!JIRA.Projects.Util.extractSelectedTab(location.href) || !(hasFragment || pushState)) {
            var tabHref = $el.find(".aui-page-panel-nav li.active > a.browse-tab").attr("href");
            var newTab = JIRA.Projects.Util.extractSelectedTab(tabHref);
            var newTabQueryString = JIRA.Projects.Util.setSelectedTab(location.href, newTab);
            history.navigate(newTabQueryString, {trigger: false, replace: true});
        }
    }
};
