/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.web.filter;

import com.atlassian.core.filters.AbstractHttpFilter;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.MutableIssue;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.projects.web.filter.BrowseProjectUrlHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.JiraContactHelper;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.io.IOException;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;

public class BrowseProjectRedirectFilter
extends AbstractHttpFilter {
    private static final String SLASH_BROWSE = "/browse";
    private static final String SLASH_BROWSE_SLASH = "/browse/";
    private static final String OLD_PLUGIN_KEY = "com.atlassian.jira.plugin.system.project";
    private static final String NEW_PLUGIN_KEY = "com.atlassian.jira.jira-projects-plugin";
    private final ProjectManager projectManager;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext authenticationContext;

    @Inject
    public BrowseProjectRedirectFilter(@ComponentImport ProjectManager projectManager, @ComponentImport IssueManager issueManager, @ComponentImport JiraAuthenticationContext authenticationContext) {
        this.projectManager = projectManager;
        this.issueManager = issueManager;
        this.authenticationContext = authenticationContext;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String requestURI = request.getRequestURI();
        String pathInfo = StringUtils.substringAfter((String)requestURI, (String)SLASH_BROWSE);
        if (StringUtils.isBlank((CharSequence)pathInfo) || pathInfo.equals("/")) {
            RequestDispatcher rd = request.getRequestDispatcher("/secure/BrowseProject.jspa");
            rd.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        BrowseProjectUrlHelper helper = new BrowseProjectUrlHelper(pathInfo);
        String projectKey = helper.getProjectKey();
        Project project = null;
        if (projectKey != null && (project = this.projectManager.getProjectObjByKey(projectKey = projectKey.toUpperCase())) == null && projectKey.endsWith("/")) {
            projectKey = projectKey.substring(0, projectKey.length() - 1);
            project = this.projectManager.getProjectObjByKey(projectKey);
        }
        if (project != null) {
            boolean projectKeyWasRenamed;
            boolean bl = projectKeyWasRenamed = !project.getKey().equals(projectKey);
            if (projectKeyWasRenamed) {
                response.sendRedirect(StringUtils.replace((String)requestURI, (String)projectKey, (String)project.getKey()));
                return;
            }
            String queryString = request.getQueryString();
            boolean legacyTabSelected = StringUtils.contains((CharSequence)queryString, (CharSequence)OLD_PLUGIN_KEY);
            if (legacyTabSelected) {
                response.sendRedirect(requestURI + "?" + StringUtils.replace((String)queryString, (String)OLD_PLUGIN_KEY, (String)NEW_PLUGIN_KEY));
                return;
            }
            if (helper.getVersionId() != null) {
                RequestDispatcher rd = request.getRequestDispatcher("/secure/BrowseProjectVersion.jspa?id=" + project.getId() + "&versionId=" + helper.getVersionId());
                rd.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (helper.getComponentId() != null) {
                RequestDispatcher rd = request.getRequestDispatcher("/secure/BrowseProjectComponent.jspa?id=" + project.getId() + "&componentId=" + helper.getComponentId());
                rd.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (helper.getProjectAvatarId() != null) {
                String avatarUrl = "/secure/projectavatar?pid=" + project.getId();
                if (helper.getProjectAvatarId() != -1L) {
                    avatarUrl = avatarUrl + "&avatarId=" + helper.getProjectAvatarId();
                }
                RequestDispatcher rd = request.getRequestDispatcher(avatarUrl);
                rd.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            RequestDispatcher rd = request.getRequestDispatcher("/secure/BrowseProject.jspa?id=" + project.getId());
            rd.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.linkToIssue(request, response, pathInfo, false)) {
            return;
        }
        String contactAdministratorLinkHtml = this.getJiraContactHelper().getAdministratorContactLinkHtml(request.getContextPath(), this.authenticationContext.getI18nHelper());
        request.setAttribute("administratorContactLink", (Object)contactAdministratorLinkHtml);
        RequestDispatcher rd = request.getRequestDispatcher("/secure/views/projectnotfound.jsp");
        response.setStatus(404);
        rd.forward((ServletRequest)request, (ServletResponse)response);
    }

    private boolean linkToIssue(HttpServletRequest request, HttpServletResponse response, String pathInfo, boolean redirectAlways) throws IOException, ServletException {
        String originalKey = pathInfo.substring(1, pathInfo.length());
        String key = originalKey.toUpperCase();
        MutableIssue issue = this.issueManager.getIssueObject(key);
        String issueKeyToUse = null;
        if (issue != null && !issue.getKey().equals(key) || issue != null && !issue.getKey().equals(originalKey)) {
            issueKeyToUse = issue.getKey();
        } else if (redirectAlways) {
            issueKeyToUse = key;
        }
        if (issueKeyToUse != null) {
            String contextPath = request.getContextPath() != null ? request.getContextPath() : "";
            String queryString = request.getQueryString() != null ? '?' + request.getQueryString() : "";
            response.sendRedirect(contextPath + SLASH_BROWSE_SLASH + issueKeyToUse + queryString);
            return true;
        }
        return false;
    }

    JiraContactHelper getJiraContactHelper() {
        return (JiraContactHelper)ComponentAccessor.getComponentOfType(JiraContactHelper.class);
    }
}

