/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.impl;

import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.plugin.projectpanel.impl.AbstractProjectTabPanel;
import com.atlassian.jira.plugin.util.TabPanelUtil;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.projects.legacy.projectpanel.impl.PermissionHelper;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.DateFieldFormat;
import com.atlassian.jira.util.velocity.DefaultVelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import webwork.action.ActionContext;

public class VersionsProjectTabPanel
extends AbstractProjectTabPanel {
    private static final Logger log = Logger.getLogger(VersionsProjectTabPanel.class);
    private static final int SUBSET_DEFAULT_VALUE = 20;
    private final VersionManager versionManager;
    private final ApplicationProperties applicationProperties;
    private final FieldVisibilityManager fieldVisibilityManager;
    private final DateFieldFormat dateFieldFormat;
    private final PermissionHelper permissionHelper;

    @Inject
    public VersionsProjectTabPanel(JiraAuthenticationContext authenticationContext, VersionManager versionManager, ApplicationProperties applicationProperties, PermissionManager permissionManager, FieldVisibilityManager fieldVisibilityManager, @ComponentImport DateFieldFormat dateFieldFormat) {
        super(authenticationContext);
        this.versionManager = versionManager;
        this.applicationProperties = applicationProperties;
        this.fieldVisibilityManager = fieldVisibilityManager;
        this.dateFieldFormat = dateFieldFormat;
        this.permissionHelper = new PermissionHelper(permissionManager);
    }

    public String getHtml(BrowseContext ctx) {
        this.setSubset();
        return super.getHtml(ctx);
    }

    public boolean showPanel(BrowseContext ctx) {
        Long projectId = ctx.getProject().getId();
        return this.isFixForVersionsFieldVisible(projectId) && !this.versionManager.getVersions(projectId).isEmpty();
    }

    public DateFieldFormat getDateFieldFormat() {
        return this.dateFieldFormat;
    }

    protected Map<String, Object> createVelocityParams(BrowseContext ctx) {
        Project project = ctx.getProject();
        List<Version> versions = this.getVersions(project);
        Map params = super.createVelocityParams(ctx);
        params.put("versionsCount", versions.size());
        Integer subset = this.getSubset();
        Collection versionToDisplay = TabPanelUtil.subSetCollection(versions, (int)subset);
        params.put("versions", versionToDisplay);
        params.put("hasAdminPermission", this.permissionHelper.hasProjectAdminPermission(this.authenticationContext.getLoggedInUser(), project));
        params.put("showingAll", versions.size() < 20);
        params.put("subset", subset);
        params.put("dateFieldFormat", this.dateFieldFormat);
        return params;
    }

    private List<Version> getVersions(Project project) {
        List<Version> versions = Collections.emptyList();
        if (this.isFixForVersionsFieldVisible(project.getId())) {
            try {
                versions = new ArrayList<Version>(this.versionManager.getVersionsUnarchived(project.getId()));
                Collections.reverse(versions);
            }
            catch (DataAccessException e) {
                log.error((Object)("Could not retrieve versions for project: " + project), (Throwable)e);
            }
        }
        return versions;
    }

    protected boolean isFixForVersionsFieldVisible(Long projectId) {
        return !this.fieldVisibilityManager.isFieldHiddenInAllSchemes(projectId, "fixVersions", null);
    }

    private void setSubset() {
        String subsetReq = this.getSubsetRequestParam();
        if (StringUtils.isNotEmpty((String)subsetReq)) {
            ActionContext.getSession().put("jira.version.browser.report.subset", new Integer(subsetReq));
        }
    }

    private Integer getSubset() {
        Integer subset = (Integer)ActionContext.getSession().get("jira.version.browser.report.subset");
        if (subset == null) {
            String requestParameter = this.getSubsetRequestParam();
            subset = StringUtils.isEmpty((String)requestParameter) ? Integer.valueOf(20) : new Integer(requestParameter);
            ActionContext.getSession().put("jira.version.browser.report.subset", subset);
        }
        return subset;
    }

    private String getSubsetRequestParam() {
        DefaultVelocityRequestContextFactory vf = new DefaultVelocityRequestContextFactory(this.applicationProperties);
        VelocityRequestContext context = vf.getJiraVelocityRequestContext();
        return context.getRequestParameter("subset");
    }
}

