/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.projectpanel.impl;

import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.plugin.projectpanel.impl.VersionDrillDownRenderer;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionManager;
import com.atlassian.jira.web.FieldVisibilityManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collection;

public class ChangeLogProjectTabPanel
implements ProjectTabPanel {
    private final VersionManager versionManager;
    private final VersionDrillDownRenderer panelRenderer;
    private final FieldVisibilityManager fieldVisibilityManager;
    private ProjectTabPanelModuleDescriptor descriptor;

    public ChangeLogProjectTabPanel(@ComponentImport VersionManager versionManager, @ComponentImport VersionDrillDownRenderer panelRenderer, @ComponentImport FieldVisibilityManager fieldVisibilityManager) {
        this.versionManager = versionManager;
        this.panelRenderer = panelRenderer;
        this.fieldVisibilityManager = fieldVisibilityManager;
    }

    public void init(ProjectTabPanelModuleDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public String getHtml(BrowseContext ctx) {
        return this.panelRenderer.getHtml(ctx, this.descriptor.getCompleteKey(), this.getVersionsToRenderFor(ctx));
    }

    public boolean showPanel(BrowseContext ctx) {
        return !this.hasNoVersions(ctx.getProject()) && !this.isFixForVersionFieldHiddenForAllSchemesOf(ctx.getProject());
    }

    private boolean hasNoVersions(Project project) {
        return this.versionManager.getVersions(project.getId()).isEmpty();
    }

    private boolean isFixForVersionFieldHiddenForAllSchemesOf(Project project) {
        return this.fieldVisibilityManager.isFieldHiddenInAllSchemes(project.getId(), "fixVersions");
    }

    private Collection<Version> getVersionsToRenderFor(BrowseContext ctx) {
        return this.versionManager.getVersionsReleasedDesc(ctx.getProject().getId(), false);
    }
}

