/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.legacy.componentpanel;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.bc.project.component.ProjectComponent;
import com.atlassian.jira.issue.search.constants.SimpleFieldSearchConstantsWithEmpty;
import com.atlassian.jira.issue.search.constants.SystemSearchConstants;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.plugin.componentpanel.BrowseComponentContext;
import com.atlassian.jira.plugin.webfragment.model.ComponentHelper;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.browse.BrowseProjectContext;
import com.atlassian.query.Query;
import com.atlassian.query.QueryImpl;
import com.atlassian.query.clause.AndClause;
import com.atlassian.query.clause.Clause;
import com.atlassian.query.clause.TerminalClause;
import com.atlassian.query.clause.TerminalClauseImpl;
import com.atlassian.query.operator.Operator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class BrowseComponentContextImpl
extends BrowseProjectContext
implements BrowseComponentContext {
    private final SimpleFieldSearchConstantsWithEmpty searchConstants = SystemSearchConstants.forComponent();
    private final SearchService searchService;
    private final ProjectComponent component;
    private final HttpServletRequest request;
    private TerminalClause componentClause;

    public BrowseComponentContextImpl(SearchService searchService, ProjectComponent component, User user, HttpServletRequest request) {
        super(user, null);
        this.searchService = searchService;
        this.component = component;
        this.request = request;
    }

    public ProjectComponent getComponent() {
        return this.component;
    }

    public Project getProject() {
        if (this.project == null) {
            this.project = this.getProjectManager().getProjectObj(this.component.getProjectId());
        }
        return this.project;
    }

    public Query createQuery() {
        Query superQuery = super.createQuery();
        JqlQueryBuilder builder = JqlQueryBuilder.newBuilder((Query)superQuery);
        builder.where().and().addClause((Clause)this.getComponentSearchClause());
        return builder.buildQuery();
    }

    protected TerminalClause getComponentSearchClause() {
        if (this.componentClause == null) {
            this.componentClause = new TerminalClauseImpl(this.searchConstants.getJqlClauseNames().getPrimaryName(), Operator.EQUALS, this.component.getName());
        }
        return this.componentClause;
    }

    public String getQueryString() {
        QueryImpl query = new QueryImpl((Clause)new AndClause(new Clause[]{this.getComponentSearchClause(), this.getProjectClause()}));
        return this.searchService.getQueryString(this.getUser(), (Query)query);
    }

    public Map<String, Object> createParameterMap() {
        Map map = super.createParameterMap();
        map.put("component", this.getComponent());
        map.put("helper", this.getHelper());
        map.put("contextType", "component");
        return map;
    }

    public String getContextKey() {
        return super.getContextKey() + "_component" + this.component.getId();
    }

    private JiraHelper getHelper() {
        return new ComponentHelper(this.request, (BrowseComponentContext)this);
    }
}

