/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page;

import com.atlassian.pageobjects.binder.WaitUntil;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Conditions;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.openqa.selenium.By;

public class Subnavigator {
    private PageElement trigger;
    private PageElement options;
    private PageElement title;
    @Inject
    private PageElementFinder pageElementFinder;

    @WaitUntil
    public void ready() {
        String triggerSelector = ".subnavigator-trigger";
        String optionsSelector = ".subnavigator-content";
        String titleSelector = ".subnavigator-title";
        this.trigger = this.pageElementFinder.find(By.cssSelector((String)triggerSelector));
        this.options = this.pageElementFinder.find(By.cssSelector((String)optionsSelector));
        this.title = this.pageElementFinder.find(By.cssSelector((String)titleSelector));
        Conditions.CombinableCondition subnavIsVisible = Conditions.or((TimedQuery[])new TimedQuery[]{this.trigger.timed().isVisible(), this.title.timed().isVisible()});
        Poller.waitUntilTrue((TimedQuery)subnavIsVisible);
    }

    public void open() {
        if (!this.isOpen()) {
            this.trigger.click();
        }
        Poller.waitUntilTrue((TimedQuery)this.options.timed().isVisible());
    }

    public void close() {
        if (this.isOpen()) {
            this.trigger.click();
        }
        Poller.waitUntilFalse((TimedQuery)this.options.timed().isVisible());
    }

    public boolean isOpen() {
        return this.options != null && this.options.isVisible();
    }

    public void selectItem(String itemId) {
        this.open();
        PageElement item = this.options.find(this.itemByIdSelector(itemId));
        if (item != null) {
            item.click();
        }
    }

    public String getTriggerText() {
        return this.trigger.getText();
    }

    public Boolean triggerIsPresent() {
        return this.trigger.isPresent();
    }

    public String getSelectedItemText() {
        this.open();
        String text = this.options.find(By.cssSelector((String)"li a[aria-checked=true]")).getText();
        this.close();
        return text;
    }

    public List<String> getAllItems() {
        this.open();
        ArrayList items = Lists.newArrayList((Object[])new String[]{this.getTitleText()});
        for (PageElement anchorElement : this.options.findAll(By.cssSelector((String)"a[data-item-id]"))) {
            items.add(anchorElement.getText());
        }
        this.close();
        return items;
    }

    public String getTitleText() {
        return this.title.getText();
    }

    public boolean hasItemWithId(String itemId) {
        return this.options.find(this.itemByIdSelector(itemId)).isPresent();
    }

    private By itemByIdSelector(String itemId) {
        return By.cssSelector((String)("[data-item-id='" + itemId + "']"));
    }
}

