/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.projects.pageobjects.webdriver.page;

import com.atlassian.jira.pageobjects.components.DropDown;
import com.atlassian.jira.pageobjects.components.fields.SingleSelect;
import com.atlassian.jira.pageobjects.framework.util.TimedQueryFactory;
import com.atlassian.jira.pageobjects.util.TraceContext;
import com.atlassian.jira.pageobjects.util.Tracer;
import com.atlassian.jira.projects.pageobjects.func.support.TestUtilities;
import com.atlassian.jira.projects.pageobjects.webdriver.page.RetryControls;
import com.atlassian.jira.projects.pageobjects.webdriver.page.components.ComponentEditPage;
import com.atlassian.jira.projects.pageobjects.webdriver.page.components.DeleteComponentDialog;
import com.atlassian.jira.projects.pageobjects.webdriver.page.sidebar.SidebarBrowseProjectSubPage;
import com.atlassian.jira.webtest.webdriver.util.AUIFlags;
import com.atlassian.pageobjects.PageBinder;
import com.atlassian.pageobjects.ProductInstance;
import com.atlassian.pageobjects.binder.Init;
import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.openqa.selenium.By;

public abstract class AbstractComponentsPage<T extends AbstractComponentsPage>
extends SidebarBrowseProjectSubPage {
    public static final String COMPONENTS_PAGE_KEY = "com.atlassian.jira.jira-projects-plugin:components-page";
    protected final String projectKey;
    protected final String contains;
    @ElementBy(id="components-page")
    private PageElement pageElement;
    @ElementBy(id="components-table")
    private PageElement componentsTable;
    @ElementBy(id="filter-container")
    private PageElement filterContainer;
    @ElementBy(cssSelector=".component-filter-status-container .component-filter-status-active")
    private PageElement activeButton;
    @ElementBy(cssSelector=".component-filter-status-container .component-filter-status-archived")
    private PageElement archivedButton;
    @ElementBy(id="pagination-container")
    private PageElement paginationContainer;
    @ElementBy(cssSelector=".no-results")
    private PageElement noResultsContainer;
    @ElementBy(cssSelector=".no-components")
    private PageElement noComponentsContainer;
    @ElementBy(cssSelector=".components-table__row-empty img.components-logo")
    private PageElement emptySearchImage;
    @ElementBy(cssSelector=".no-components img.components-logo")
    private PageElement noComponentsImage;
    @Inject
    private PageBinder pageBinder;
    @Inject
    private ProductInstance jiraProduct;
    @Inject
    TimedQueryFactory timedQueryFactory;
    @Inject
    TraceContext traceContext;
    @Inject
    AUIFlags flags;
    private boolean obsolete = false;
    public static String STATUS_NO_FILTER = "no-filter";
    public static final String STATUS_ARCHIVED = "ARCHIVED";
    public static final String STATUS_ACTIVE = "ACTIVE";
    public static String STATUS_ALL = "all";
    private final String STATUS_BUTTON_CHECKED_CLASS = "component-filter-status-pressed";
    private final String STATUS_CHANGED_CHECKPOINT = "project.components.status.changed";

    public AbstractComponentsPage(String projectKey) {
        this(projectKey, null);
    }

    public AbstractComponentsPage(String projectKey, String contains) {
        super(projectKey);
        this.projectKey = projectKey;
        this.contains = contains;
    }

    @Override
    public String getUrl() {
        return super.getUrl() + TestUtilities.appendQueryParam(new StringBuilder(), "contains", this.contains).toString();
    }

    public AbstractComponentsPage ready() {
        String url = this.jiraProduct.getBaseUrl() + this.getUrl();
        Poller.waitUntil((String)"Failed to bind because URL is different then the expected one.", (TimedQuery)this.timedQueryFactory.forSupplier(() -> this.driver.getCurrentUrl(), TimeoutType.PAGE_LOAD), (Matcher)Is.is((Object)url));
        this.flags.closeAllFlags();
        return this;
    }

    @Override
    public String getPageId() {
        return COMPONENTS_PAGE_KEY;
    }

    public Component getComponentByName(String name) {
        PageElement tableRow = this.getComponentElement(name);
        return (Component)this.pageBinder.bind(Component.class, new Object[]{tableRow, this.projectKey});
    }

    public boolean hasComponent(String name) {
        return (Boolean)this.getComponentElement(name).timed().isPresent().byDefaultTimeout();
    }

    public boolean hasComponentWithStatus(String status) {
        String xpath = "//tbody[@class=\"items\"]//td[@class=\"components-table__status\"]/div[text()=\"%s\" or a/text()=\"%s\"]/../..";
        return this.componentsTable.findAll(By.xpath((String)String.format(xpath, status, status))).size() > 0;
    }

    private PageElement getComponentElement(String name) {
        this.assertNotObsolete();
        String xpath = "//tbody[@class=\"items\"]//td[@class=\"components-table__name\"]/div[text()=\"%s\" or a/text()=\"%s\"]/../..";
        return this.componentsTable.find(By.xpath((String)String.format(xpath, name, name)));
    }

    public Component getComponentAt(int position) {
        this.assertNotObsolete();
        String selector = "tbody.items tr:nth-child(%d)";
        PageElement tableRow = this.componentsTable.find(By.cssSelector((String)String.format(selector, position)));
        return (Component)this.pageBinder.bind(Component.class, new Object[]{tableRow, this.projectKey});
    }

    public int getComponentCount() {
        this.assertNotObsolete();
        String selector = "tbody.items tr:not(.components-table__row-empty)";
        return this.componentsTable.findAll(By.cssSelector((String)selector)).size();
    }

    public TimedCondition isEmpty() {
        return this.componentsTable.find(By.cssSelector((String)".no-results")).timed().isPresent();
    }

    public T filterByText(String text) {
        this.assertNotObsolete();
        this.filterContainer.find(By.id((String)"component-filter-text")).clear().type(new CharSequence[]{text});
        return (T)((Object)this.bindPage(this.projectKey, text));
    }

    public void toggleActive(boolean isChecked) {
        boolean isSelected = this.activeButton.hasClass("component-filter-status-pressed");
        Tracer checkpoint = this.traceContext.checkpoint();
        if (!isSelected && isChecked || isSelected && !isChecked) {
            this.activeButton.click();
            this.traceContext.waitFor(checkpoint, "project.components.status.changed");
        }
    }

    public void toggleArchived(boolean isChecked) {
        boolean isSelected = this.archivedButton.hasClass("component-filter-status-pressed");
        Tracer checkpoint = this.traceContext.checkpoint();
        if (!isSelected && isChecked || isSelected && !isChecked) {
            this.archivedButton.click();
            this.traceContext.waitFor(checkpoint, "project.components.status.changed");
        }
    }

    public TimedCondition isArchivedButtonPresent() {
        return this.archivedButton.timed().isPresent();
    }

    public TimedCondition isArchivedSelected() {
        return this.archivedButton.timed().hasClass("component-filter-status-pressed");
    }

    public void revealNextPage() {
        int currentCount = this.getComponentCount();
        Tracer tracer = this.traceContext.checkpoint();
        this.scrollToBottom();
        this.traceContext.waitFor(tracer, "jira.projects.scroll.checked");
        Poller.waitUntil((TimedQuery)this.timedQueryFactory.forSupplier(this::getComponentCount), (Matcher)Is.is((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(currentCount))));
    }

    private void scrollToBottom() {
        this.javascriptExecutor.executeScript("window.scrollTo(0, document.body.scrollHeight)", new Object[0]);
    }

    public static Map<String, String> getFilterParamsFromUrl(String url) {
        HashMap params = Maps.newHashMap();
        if (url.contains("?")) {
            String[] hashParams;
            for (String param : hashParams = url.split("[?]")[1].split("&")) {
                String[] paramParts = param.split("=");
                if (paramParts.length != 2) continue;
                params.put(paramParts[0], paramParts[1]);
            }
        }
        return params;
    }

    private AbstractComponentsPage bindPage(String projectKey, String contains) {
        this.obsolete = true;
        return ((AbstractComponentsPage)((Object)this.pageBinder.bind(((Object)((Object)this)).getClass(), new Object[]{projectKey, contains}))).ready();
    }

    private AbstractComponentsPage bindPage(String projectKey, String status, String contains) {
        this.obsolete = true;
        return ((AbstractComponentsPage)((Object)this.pageBinder.bind(((Object)((Object)this)).getClass(), new Object[]{projectKey, status, contains}))).ready();
    }

    private void assertNotObsolete() {
        if (this.obsolete) {
            throw new IllegalStateException("This page object produced another one. It is obsolete and the new one should be used instead.");
        }
    }

    public ComponentForm getComponentForm() {
        return (ComponentForm)this.pageBinder.bind(ComponentForm.class, new Object[]{this.pageElement.find(By.id((String)"components-add__component"))});
    }

    public TimedCondition isEmptySearchImagePresent() {
        return this.emptySearchImage.timed().isPresent();
    }

    public TimedCondition isNoComponentsImagePresent() {
        return this.noComponentsImage.timed().isPresent();
    }

    public void scrollToTop() {
        this.javascriptExecutor.executeScript("window.scrollTo(0, 0)", new Object[0]);
    }

    public TimedCondition hasNoResultsContainer() {
        return this.noResultsContainer.timed().isPresent();
    }

    public TimedCondition hasNoComponentsContainer() {
        return this.noComponentsContainer.timed().isPresent();
    }

    public static class ComponentForm {
        @Inject
        private PageBinder pageBinder;
        @Inject
        private TraceContext traceContext;
        private PageElement componentForm;

        public ComponentForm(PageElement componentForm) {
            this.componentForm = componentForm;
        }

        private void fillField(String name, String value) {
            this.componentForm.find(By.cssSelector((String)String.format(".components-add__%s input", name))).type(new CharSequence[]{value});
        }

        private void selectValue(String name, String value) {
            SingleSelect select = (SingleSelect)this.pageBinder.bind(SingleSelect.class, new Object[]{this.componentForm.find(By.cssSelector((String)String.format(".components-add__%s", name)))});
            select.select(value);
        }

        public SingleSelect getLeadField() {
            return (SingleSelect)this.pageBinder.bind(SingleSelect.class, new Object[]{this.componentForm.find(By.cssSelector((String)".components-add__lead"))});
        }

        public SingleSelect getDefaultAssigneeField() {
            return (SingleSelect)this.pageBinder.bind(SingleSelect.class, new Object[]{this.componentForm.find(By.cssSelector((String)".components-add__assignee"))});
        }

        public void addComponent(String name, String leadUserName, String description, String assignedOption) {
            Tracer tracer = this.traceContext.checkpoint();
            this.fillField("name", name);
            this.selectValue("lead", leadUserName);
            this.fillField("description", description);
            this.selectValue("assignee", assignedOption);
            PageElement button = this.componentForm.find(By.cssSelector((String)".components-add__confirm button"));
            Poller.waitUntilTrue((TimedQuery)button.timed().isEnabled());
            button.click();
            this.traceContext.waitFor(tracer, "jira.components.add.finished");
        }

        public TimedCondition isPresent() {
            return this.componentForm.timed().isPresent();
        }
    }

    public static class ActionsDropDown
    extends DropDown {
        private PageElement actionsTrigger;

        public ActionsDropDown(PageElement actionsTrigger, By dropdownLocator) {
            super(null, dropdownLocator);
            this.actionsTrigger = actionsTrigger;
        }

        protected PageElement trigger() {
            return this.actionsTrigger;
        }

        public boolean isVisible() {
            return this.actionsTrigger.isVisible();
        }
    }

    public static class Component {
        @Inject
        private PageBinder pageBinder;
        @Inject
        private PageElementFinder finder;
        private final PageElement rowElement;
        private PageElement name;
        private PageElement description;
        private PageElement issuesCount;
        private PageElement leadName;
        private PageElement status;
        private PageElement assignee;
        private PageElement actionsTrigger;
        private PageElement retryContainer;
        private ActionsDropDown dropDown;
        private Long componentId;
        private String projectKey;

        public Component(PageElement rowElement, String projectKey) {
            this.rowElement = rowElement;
            this.projectKey = projectKey;
        }

        @Init
        public void initContent() {
            this.componentId = NumberUtils.toLong((String)this.getId(), (long)-1L);
            this.name = this.rowElement.find(By.cssSelector((String)".components-table__name a"));
            this.description = this.rowElement.find(By.cssSelector((String)".components-table__description div"));
            this.issuesCount = this.rowElement.find(By.cssSelector((String)".components-table__issues-count a"));
            this.leadName = this.rowElement.find(By.cssSelector((String)".components-table__lead"));
            this.assignee = this.rowElement.find(By.cssSelector((String)".components-table__assignee div"));
            this.status = this.rowElement.find(By.cssSelector((String)".components-table__status span"));
            this.retryContainer = this.rowElement.find(By.cssSelector((String)".operation-retry"));
        }

        private PageElement getActionsTrigger() {
            if (this.actionsTrigger == null) {
                this.actionsTrigger = this.rowElement.find(By.cssSelector((String)".dynamic-table__actions .aui-dropdown2-trigger"));
            }
            return this.actionsTrigger;
        }

        public <T> T clickName(Class<T> pageClass, Object ... args) {
            this.name.click();
            return (T)this.pageBinder.bind(pageClass, args);
        }

        public String getId() {
            return this.rowElement.getAttribute("data-component-id");
        }

        public TimedQuery<String> getName() {
            return this.name.timed().getText();
        }

        public TimedQuery<String> getDescription() {
            return this.description.timed().getText();
        }

        public TimedQuery<String> getIssuesCount() {
            return this.issuesCount.timed().getText();
        }

        public TimedQuery<String> getLeadName() {
            return this.leadName.timed().getText();
        }

        public TimedQuery<String> getAssignee() {
            return this.assignee.timed().getText();
        }

        public TimedQuery<String> getAssigneeTitle() {
            return this.assignee.timed().getAttribute("original-title");
        }

        public TimedQuery<String> getStatus() {
            return this.status.timed().getText();
        }

        public ActionsDropDown getDropDown() {
            if (this.dropDown == null) {
                this.dropDown = (ActionsDropDown)((Object)this.pageBinder.bind(ActionsDropDown.class, new Object[]{this.getActionsTrigger(), By.id((String)((String)this.getActionsTrigger().timed().getAttribute("aria-controls").byDefaultTimeout()))}));
            }
            return this.dropDown;
        }

        public ComponentEditPage edit() {
            if (!this.isEditable()) {
                throw new IllegalStateException("Component is not editable");
            }
            this.getDropDown().open().openAndClick(By.className((String)"editcomponent_link"));
            return (ComponentEditPage)((Object)this.pageBinder.bind(ComponentEditPage.class, new Object[]{this.componentId, this.projectKey}));
        }

        public void archive() {
            this.getDropDown().open().openAndClick(By.className((String)"archivecomponent_link"));
        }

        public void restore() {
            this.getDropDown().open().openAndClick(By.className((String)"project-config-operations-unarchive"));
        }

        public DeleteComponentDialog delete() {
            this.getDropDown().open().openAndClick(By.className((String)"deletecomponent_link"));
            return (DeleteComponentDialog)((Object)this.pageBinder.bind(DeleteComponentDialog.class, new Object[]{Long.toString(this.componentId), this.projectKey}));
        }

        public boolean isEditable() {
            return this.getActionsTrigger() != null && this.getActionsTrigger().isPresent() && this.getActionsTrigger().isVisible();
        }

        public TimedQuery<Boolean> isVisible() {
            return this.rowElement.timed().isVisible();
        }

        public RetryControls getRetryControls() {
            Poller.waitUntilTrue((TimedQuery)this.retryContainer.timed().isPresent());
            return (RetryControls)this.pageBinder.bind(RetryControls.class, new Object[]{this.retryContainer});
        }

        public Collection<String> getCssClasses() {
            return Arrays.asList(StringUtils.defaultString((String)this.rowElement.getAttribute("class")).split(" "));
        }

        public boolean hasErrorClass() {
            return this.getCssClasses().contains("item-state-error-add") || this.getCssClasses().contains("item-state-error-delete") || this.getCssClasses().contains("item-state-error-update");
        }
    }
}

