/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.link.web;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.issue.comment.CommentService;
import com.atlassian.jira.bc.issue.link.RemoteIssueLinkService;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.screen.FieldScreenRendererFactory;
import com.atlassian.jira.issue.link.RemoteIssueLink;
import com.atlassian.jira.issue.link.RemoteIssueLinkBuilder;
import com.atlassian.jira.security.roles.ProjectRoleManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.user.util.UserUtil;
import com.atlassian.jira.web.action.issue.AbstractIssueLinkAction;

public class AddWebLink
extends AbstractIssueLinkAction {
    private String iconUrl;
    private String url;
    private String title;

    public AddWebLink(SubTaskManager subTaskManager, FieldScreenRendererFactory fieldScreenRendererFactory, FieldManager fieldManager, ProjectRoleManager projectRoleManager, CommentService commentService, UserUtil userUtil, RemoteIssueLinkService remoteIssueLinkService, EventPublisher eventPublisher) {
        super(subTaskManager, fieldScreenRendererFactory, fieldManager, projectRoleManager, commentService, userUtil, remoteIssueLinkService, eventPublisher);
    }

    protected void doValidation() {
        super.doValidation();
        RemoteIssueLink remoteIssueLink = new RemoteIssueLinkBuilder().issueId(this.getIssue().getLong("id")).iconUrl(this.iconUrl).url(this.url).title(this.title).build();
        this.validationResult = this.remoteIssueLinkService.validateCreate(this.getLoggedInUser(), remoteIssueLink);
        if (!this.validationResult.isValid()) {
            this.addErrorCollection(this.validationResult.getErrorCollection());
        }
    }

    public String doDefault() throws Exception {
        this.url = "http://";
        return super.doDefault();
    }

    @RequiresXsrfCheck
    protected String doExecute() {
        RemoteIssueLinkService.RemoteIssueLinkResult result = this.createLink();
        if (!result.isValid()) {
            this.addErrorCollection(result.getErrorCollection());
            return "error";
        }
        this.createComment();
        return this.returnComplete(this.getRedirectUrl());
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

